/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.lang.reflect.Array;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.ObjectLinkedList;

public final class HashIndex<T> {
    protected final HashElement<T>[][] hash;
    protected final int mask;

    private HashIndex() {
        this.hash = null;
        this.mask = -1;
    }

    public HashIndex(Object index) {
        ObjectLinkedList ary;
        int no;
        int len = Array.getLength(index);
        int bitLen = MimdbUtils.bitMask(len) << 1;
        int msk = bitLen - 1;
        ObjectLinkedList[] work = new ObjectLinkedList[bitLen];
        for (int i = 0; i < len; ++i) {
            Object n = Array.get(index, i);
            int hash = n.hashCode();
            no = hash & msk;
            ary = work[no];
            if (ary == null) {
                work[no] = ary = new ObjectLinkedList();
            }
            ary.offer(i);
        }
        HashElement[][] hman = new HashElement[bitLen][];
        for (int i = 0; i < bitLen; ++i) {
            ary = work[i];
            if (ary == null) {
                hman[i] = new HashElement[0];
                continue;
            }
            int lenJ = ary.size();
            HashElement[] ha = new HashElement[lenJ];
            hman[i] = ha;
            for (int j = 0; j < lenJ; ++j) {
                no = (Integer)ary.poll();
                HashElement h = new HashElement();
                h.value = Array.get(index, no);
                h.no = no;
                ha[j] = h;
            }
        }
        work = null;
        this.hash = hman;
        this.mask = msk;
    }

    public int eq(T value) {
        HashElement<T>[] ary = this.hash[value.hashCode() & this.mask];
        int len = ary.length;
        for (int i = 0; i < len; ++i) {
            if (!value.equals(ary[i].value)) continue;
            return ary[i].no;
        }
        return -1;
    }

    private static final class HashElement<T> {
        T value;
        int no;

        private HashElement() {
        }
    }
}

