/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.impl.LikeParser;
import org.maachang.mimdb.core.impl.LikeParserImpl;
import org.maachang.mimdb.core.util.ObjectList;

public final class LikeAnalyzer {
    private LikeAnalyzer() {
    }

    public static final LikeParser parser(String like) throws Exception {
        if (like == null || like.length() <= 0) {
            throw new MimdbException("Like\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        StringBuilder buf = null;
        boolean yenFlag = false;
        int type = -1;
        int pos = 0;
        int len = like.length();
        ObjectList<Object> ret = new ObjectList<Object>();
        for (int i = 0; i < len; ++i) {
            char c = like.charAt(i);
            if (!(yenFlag || c != '%' && c != '*' && c != '_' && c != '?')) {
                if (buf != null) {
                    if (ret.size() == 0) {
                        ret.add(0);
                        type = -1;
                        pos = 0;
                    }
                    ret.add(buf.toString());
                    buf = null;
                }
                if (c == '%' || c == '*') {
                    if (type != 0) {
                        ret.add(-1);
                    }
                    type = 0;
                    pos = 0;
                } else if (c == '_' || c == '?') {
                    if (type == -1) {
                        type = 1;
                        pos = 1;
                    } else if (type == 1) {
                        ++pos;
                    }
                }
            } else {
                if (c == '\\') {
                    yenFlag = true;
                    continue;
                }
                if (buf == null) {
                    if (type == 1) {
                        ret.add(pos);
                    }
                    buf = new StringBuilder();
                }
                buf.append(c);
                type = -1;
                pos = 0;
            }
            yenFlag = false;
        }
        if (type == 0) {
            if (buf != null) {
                ret.add(buf.toString());
                buf = null;
            }
            if ((Integer)ret.get(ret.size() - 1) != -1) {
                ret.add(-1);
            }
        } else if (type == 1 && pos > 0) {
            if (buf != null) {
                ret.add(buf.toString());
                buf = null;
            }
            ret.add(pos);
        } else if (buf != null) {
            if (ret.size() == 0) {
                ret.add(0);
            }
            ret.add(-9);
            ret.add(buf.toString());
            buf = null;
        }
        return new LikeParserImpl(ret.getArray(), like);
    }

    public static final boolean match(LikeParser parser, String value) throws Exception {
        if (value == null || value.length() <= 0) {
            return false;
        }
        Object[] ps = ((LikeParserImpl)parser).parser;
        int len = ps.length;
        if (len == 1) {
            int n = (Integer)ps[0];
            if (n == -1) {
                return true;
            }
            return value.length() == n;
        }
        if (len == 3 && ps[0] instanceof Integer && ps[1] instanceof Integer && ps[2] instanceof String && (Integer)ps[0] == 0 && (Integer)ps[1] == -9) {
            return value.equals(ps[2]);
        }
        int p = 0;
        int b = 0;
        int n = -99;
        boolean last = false;
        String bw = null;
        for (int i = 0; i < len; ++i) {
            if (ps[i] instanceof Integer) {
                if ((Integer)ps[i] == -9) {
                    last = true;
                    continue;
                }
                n = (Integer)ps[i];
                continue;
            }
            String v = (String)ps[i];
            if (n > 0) {
                if (bw == null) {
                    if (value.length() < b + n + v.length() || !v.equals(value.substring(b + n, b + n + v.length()))) {
                        return false;
                    }
                } else {
                    while (value.length() < b + n + v.length() || !v.equals(value.substring(b + n, b + n + v.length()))) {
                        p = value.indexOf(bw, b);
                        if (p == -1) {
                            return false;
                        }
                        b = p + bw.length();
                    }
                }
                if (last) {
                    return b + n + v.length() == value.length();
                }
                b = b + n + v.length();
                n = -99;
                bw = null;
            } else if (!last) {
                switch (n) {
                    case 0: {
                        if (!value.startsWith(v)) {
                            return false;
                        }
                        b = v.length();
                        break;
                    }
                    case -1: {
                        p = value.indexOf(v, b);
                        if (p == -1) {
                            return false;
                        }
                        bw = v;
                        b = p + v.length();
                        break;
                    }
                    case -99: {
                        throw new MimdbException("Like\u69cb\u6587\u304c\u4e0d\u6b63\u3067\u3059");
                    }
                }
            }
            if (!last) continue;
            return value.endsWith(v);
        }
        if (n > 0) {
            if (bw == null) {
                if (value.length() != b + n) {
                    return false;
                }
            } else {
                while (value.length() != b + n) {
                    p = value.indexOf(bw, b);
                    if (p == -1) {
                        return false;
                    }
                    b = p + bw.length();
                }
            }
        }
        return true;
    }
}

