/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.ObjectList;

public class Csv {
    private BufferedReader reader = null;
    private String cut;
    private String nowLine = null;
    private int count = 0;
    private boolean eof = true;

    public Csv() {
    }

    public Csv(String name, String charset, String cut) throws Exception {
        this.open(name, charset, cut);
    }

    public Csv(Reader r, String cut) throws Exception {
        this.open(r, cut);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(String name, String charset, String cut) throws Exception {
        if (!MimdbUtils.isFile(name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d[" + name + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (charset == null || charset.length() <= 0) {
            charset = "UTF8";
        }
        if (cut == null || cut.length() <= 0) {
            cut = ",";
        }
        if (this.isOpen()) {
            this.close();
        }
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), charset));
        this.cut = cut;
        this.eof = false;
    }

    public void open(Reader r, String cut) throws Exception {
        if (cut == null || cut.length() <= 0) {
            cut = ",";
        }
        if (this.isOpen()) {
            this.close();
        }
        this.reader = new BufferedReader(r);
        this.cut = cut;
        this.eof = false;
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.reader = null;
        this.nowLine = null;
        this.count = 0;
        this.eof = true;
    }

    public boolean next() throws Exception {
        String s;
        if (!this.isOpen()) {
            return false;
        }
        do {
            if ((s = this.reader.readLine()) != null) continue;
            this.eof = true;
            return false;
        } while ((s = s.trim()).length() <= 0);
        this.nowLine = s;
        ++this.count;
        return true;
    }

    public String[] getArray() throws Exception {
        if (!this.isOpen()) {
            return null;
        }
        if (this.nowLine != null) {
            return (String[])Csv.getCsvArray(true, this.nowLine, this.cut);
        }
        return null;
    }

    public Object[] getObjects() throws Exception {
        if (!this.isOpen()) {
            return null;
        }
        if (this.nowLine != null) {
            return (Object[])Csv.getCsvArray(false, this.nowLine, this.cut);
        }
        return null;
    }

    public List<String> get() throws Exception {
        if (!this.isOpen()) {
            return null;
        }
        if (this.nowLine != null) {
            return Csv.getCsv(this.nowLine, this.cut);
        }
        return null;
    }

    public String getString() throws Exception {
        if (!this.isOpen()) {
            return null;
        }
        return this.nowLine;
    }

    public int count() {
        if (!this.isOpen()) {
            return -1;
        }
        return this.count;
    }

    public boolean isOpen() {
        return this.reader != null;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public static final String[] getCsvArray(String line, String cutCode) throws Exception {
        return (String[])Csv.getCsvArray(true, line, cutCode);
    }

    private static final Object getCsvArray(boolean mode, String line, String cutCode) throws Exception {
        String x;
        if (line == null || line.length() <= 0) {
            return mode ? new String[]{} : new Object[]{};
        }
        if (cutCode == null || cutCode.length() <= 0) {
            cutCode = ",";
        }
        int n = -1;
        int len = line.length();
        int s = 0;
        boolean yen = false;
        char cut = cutCode.charAt(0);
        ObjectList<String> tmp = new ObjectList<String>();
        for (int i = 0; i < len; ++i) {
            char c;
            char c2 = line.charAt(i);
            if (c != '\uffffffff') {
                if (!yen && c2 == c) {
                    c = '\uffffffff';
                }
            } else if (c2 == cut) {
                if (s == i) {
                    tmp.add("");
                } else {
                    x = line.substring(s, i).trim();
                    if (x.indexOf("\"") == 0 || x.indexOf("'") == 0) {
                        x = x.substring(1, x.length() - 1).trim();
                    }
                    tmp.add(x);
                }
                s = i + 1;
            } else if (!(yen || c2 != '\'' && c2 != '\"')) {
                c = c2;
            }
            yen = c2 == '\\';
        }
        if (s >= len) {
            tmp.add("");
        } else {
            x = line.substring(s, len).trim();
            if (x.indexOf("\"") == 0 || x.indexOf("'") == 0) {
                x = x.substring(1, x.length() - 1).trim();
            }
            tmp.add(x);
        }
        len = tmp.size();
        if (mode) {
            String[] ret = new String[len];
            Object[] strList = tmp.getArray();
            for (int i = 0; i < len; ++i) {
                ret[i] = (String)strList[i];
            }
            strList = null;
            tmp.clear();
            tmp = null;
            return ret;
        }
        return tmp.getArray();
    }

    public static final List<String> getCsv(String line, String cutCode) throws Exception {
        String x;
        if (line == null || line.length() <= 0) {
            return new ArrayList<String>();
        }
        if (cutCode == null || cutCode.length() <= 0) {
            cutCode = ",";
        }
        int n = -1;
        int len = line.length();
        int s = 0;
        boolean yen = false;
        char cut = cutCode.charAt(0);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char c;
            char c2 = line.charAt(i);
            if (c != '\uffffffff') {
                if (!yen && c2 == c) {
                    c = '\uffffffff';
                }
            } else if (c2 == cut) {
                if (s == i) {
                    ret.add("");
                } else {
                    x = line.substring(s, i).trim();
                    if (x.indexOf("\"") == 0 || x.indexOf("'") == 0) {
                        x = x.substring(1, x.length() - 1).trim();
                    }
                    ret.add(x);
                }
                s = i + 1;
            } else if (!(yen || c2 != '\'' && c2 != '\"')) {
                c = c2;
            }
            yen = c2 == '\\';
        }
        if (s >= len) {
            ret.add("");
        } else {
            x = line.substring(s, len).trim();
            if (x.indexOf("\"") == 0 || x.indexOf("'") == 0) {
                x = x.substring(1, x.length() - 1).trim();
            }
            ret.add(x);
        }
        return ret;
    }
}

