/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import org.maachang.mimdb.core.util.NumberKeySet;

public final class NNObjectKeyValue<K, V> {
    private static final int DEF_LENGTH = 32;
    private NNObjectKeyValueChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private int pos = 0;
    private NNObjectKeyValueChild cPos = null;
    private int count = 0;

    public NNObjectKeyValue() {
        this(32);
    }

    public NNObjectKeyValue(int size) {
        size = size <= 32 ? 32 : NumberKeySet.bitMask(size);
        this.list = new NNObjectKeyValueChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
    }

    public void clear() {
        this.list = new NNObjectKeyValueChild[this.base];
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
    }

    public void put(K b, V o) {
        int h;
        if (b == null) {
            throw new RuntimeException("\u3053\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306fNULL\u7981\u6b62\u3067\u3059");
        }
        if (this.length + 1 >= this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            NNObjectKeyValueChild[] nList = new NNObjectKeyValueChild[nLen];
            for (int i = 0; i < this.limit; ++i) {
                NNObjectKeyValueChild n = this.list[i];
                while (n != null) {
                    NNObjectKeyValueChild t;
                    h = n.b.hashCode() & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if (this.list[h = b.hashCode() & this.mask] == null) {
            this.list[h] = new NNObjectKeyValueChild(b, o);
            ++this.length;
        } else {
            int bh = b.hashCode();
            NNObjectKeyValueChild nn = this.list[h];
            while (nn.n != null) {
                if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                    nn.o = o;
                    return;
                }
                nn = nn.n;
            }
            if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                nn.o = o;
            } else {
                nn.n = new NNObjectKeyValueChild(b, o);
                ++this.length;
            }
        }
    }

    public boolean containsKey(K b) {
        if (b == null) {
            return false;
        }
        int hb = b.hashCode();
        NNObjectKeyValueChild n = this.list[hb & this.mask];
        while (n != null) {
            if (n.b.hashCode() == hb && (n.b == b || n.b.equals(b))) {
                return true;
            }
            n = n.n;
        }
        return false;
    }

    public V get(K b) {
        if (b == null) {
            return null;
        }
        int hb = b.hashCode();
        NNObjectKeyValueChild n = this.list[hb & this.mask];
        while (n != null) {
            if (n.b.hashCode() == hb && (n.b == b || n.b.equals(b))) {
                return (V)n.o;
            }
            n = n.n;
        }
        return null;
    }

    public void remove(Object b) {
        if (b == null) {
            return;
        }
        int bh = b.hashCode();
        NNObjectKeyValueChild bf = null;
        NNObjectKeyValueChild n = this.list[bh & this.mask];
        while (n != null) {
            if (n.b.hashCode() == bh && (n.b == b || n.b.equals(b))) {
                if (bf == null) {
                    this.list[bh & this.mask] = n.n == null ? null : n.n;
                } else {
                    bf.n = n.n == null ? null : n.n;
                }
                --this.length;
                break;
            }
            bf = n;
            n = n.n;
        }
    }

    public int size() {
        return this.length;
    }

    public Object[] keyArray() {
        if (this.size() == 0) {
            return null;
        }
        Object[] ret = new Object[this.length];
        int cnt = 0;
        for (int i = 0; i < this.limit; ++i) {
            if (this.list[i] == null) continue;
            NNObjectKeyValueChild n = this.list[i];
            while (n != null) {
                ret[cnt++] = n.b;
                n = n.n;
            }
        }
        return ret;
    }

    public NNObjectKeyValue<K, V> reset() {
        this.pos = 0;
        this.cPos = null;
        this.count = 0;
        return this;
    }

    public boolean hasNext() {
        if (this.cPos != null && (this.cPos = this.cPos.n) != null) {
            ++this.count;
            return true;
        }
        while (this.pos < this.limit) {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            ++this.count;
            return true;
        }
        return false;
    }

    public K next() {
        if (this.cPos == null) {
            return null;
        }
        return (K)this.cPos.b;
    }

    public V nextValue() {
        if (this.cPos == null) {
            return null;
        }
        return (V)this.cPos.o;
    }

    public int count() {
        return this.count;
    }

    private static final class NNObjectKeyValueChild {
        Object b;
        Object o;
        NNObjectKeyValueChild n;

        NNObjectKeyValueChild(Object k, Object v) {
            this.b = k;
            this.o = v;
        }
    }
}

