/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.util;

import org.maachang.mimdb.core.util.NumberKeySet;

public final class ObjectKeyValue<K, V> {
    private static final int DEF_LENGTH = 32;
    private ObjectKeyValueChild[] list;
    private int mask;
    private int length;
    private int limit;
    private int base;
    private boolean nullFlag;
    private Object nullValue;
    private int pos = 0;
    private ObjectKeyValueChild cPos = null;
    private int count = 0;
    private boolean nullOutFlag = false;

    public ObjectKeyValue() {
        this(32);
    }

    public ObjectKeyValue(int size) {
        size = size <= 32 ? 32 : NumberKeySet.bitMask(size);
        this.list = new ObjectKeyValueChild[size];
        this.length = 0;
        this.mask = size - 1;
        this.limit = size;
        this.base = size;
        this.nullFlag = false;
        this.nullValue = null;
    }

    public void clear() {
        this.list = new ObjectKeyValueChild[this.base];
        this.length = 0;
        this.mask = this.base - 1;
        this.limit = this.base;
        this.nullFlag = false;
        this.nullValue = null;
    }

    public void put(K b, V o) {
        int h;
        if (b == null) {
            this.nullFlag = true;
            this.nullValue = o;
            return;
        }
        if (this.length + 1 >= this.limit) {
            int nLen = this.limit << 1;
            int msk = nLen - 1;
            ObjectKeyValueChild[] nList = new ObjectKeyValueChild[nLen];
            for (int i = 0; i < this.limit; ++i) {
                ObjectKeyValueChild n = this.list[i];
                while (n != null) {
                    ObjectKeyValueChild t;
                    h = n.b.hashCode() & msk;
                    if (nList[h] == null) {
                        t = n.n;
                        n.n = null;
                    } else {
                        t = n.n;
                        n.n = nList[h];
                    }
                    nList[h] = n;
                    n = t;
                }
            }
            this.list = nList;
            this.limit = nLen;
            this.mask = msk;
        }
        if (this.list[h = b.hashCode() & this.mask] == null) {
            this.list[h] = new ObjectKeyValueChild(b, o);
            ++this.length;
        } else {
            int bh = b.hashCode();
            ObjectKeyValueChild nn = this.list[h];
            while (nn.n != null) {
                if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                    nn.o = o;
                    return;
                }
                nn = nn.n;
            }
            if (nn.b.hashCode() == bh && (nn.b == b || nn.b.equals(b))) {
                nn.o = o;
            } else {
                nn.n = new ObjectKeyValueChild(b, o);
                ++this.length;
            }
        }
    }

    public boolean containsKey(K b) {
        if (b == null) {
            return this.nullFlag;
        }
        int hb = b.hashCode();
        ObjectKeyValueChild n = this.list[hb & this.mask];
        while (n != null) {
            if (n.b.hashCode() == hb && (n.b == b || n.b.equals(b))) {
                return true;
            }
            n = n.n;
        }
        return false;
    }

    public V get(K b) {
        if (b == null) {
            return (V)this.nullValue;
        }
        int hb = b.hashCode();
        ObjectKeyValueChild n = this.list[hb & this.mask];
        while (n != null) {
            if (n.b.hashCode() == hb && (n.b == b || n.b.equals(b))) {
                return (V)n.o;
            }
            n = n.n;
        }
        return null;
    }

    public void remove(Object b) {
        if (b == null) {
            this.nullFlag = false;
            this.nullValue = null;
            return;
        }
        int bh = b.hashCode();
        ObjectKeyValueChild bf = null;
        ObjectKeyValueChild n = this.list[bh & this.mask];
        while (n != null) {
            if (n.b.hashCode() == bh && (n.b == b || n.b.equals(b))) {
                if (bf == null) {
                    this.list[bh & this.mask] = n.n == null ? null : n.n;
                } else {
                    bf.n = n.n == null ? null : n.n;
                }
                --this.length;
                break;
            }
            bf = n;
            n = n.n;
        }
    }

    public int size() {
        return this.nullFlag ? this.length + 1 : this.length;
    }

    public Object[] keyArray() {
        int cnt;
        Object[] ret;
        if (this.size() == 0) {
            return null;
        }
        if (this.nullFlag) {
            ret = new Object[this.length + 1];
            cnt = 1;
        } else {
            ret = new Object[this.length];
            cnt = 0;
        }
        for (int i = 0; i < this.limit; ++i) {
            if (this.list[i] == null) continue;
            ObjectKeyValueChild n = this.list[i];
            while (n != null) {
                ret[cnt++] = n.b;
                n = n.n;
            }
        }
        return ret;
    }

    public ObjectKeyValue<K, V> reset() {
        this.pos = 0;
        this.cPos = null;
        this.count = 0;
        this.nullOutFlag = false;
        return this;
    }

    public boolean hasNext() {
        if (this.count == 0) {
            if (this.nullFlag) {
                ++this.count;
                return true;
            }
            this.nullOutFlag = true;
        }
        if (this.cPos != null && (this.cPos = this.cPos.n) != null) {
            ++this.count;
            return true;
        }
        while (this.pos < this.limit) {
            if ((this.cPos = this.list[this.pos++]) == null) continue;
            ++this.count;
            return true;
        }
        return false;
    }

    public K next() {
        if (!this.nullOutFlag) {
            this.nullOutFlag = true;
            return null;
        }
        if (this.cPos == null) {
            return null;
        }
        return (K)this.cPos.b;
    }

    public V nextValue() {
        if (this.cPos == null) {
            return null;
        }
        return (V)this.cPos.o;
    }

    public int count() {
        return this.count;
    }

    private static final class ObjectKeyValueChild {
        Object b;
        Object o;
        ObjectKeyValueChild n;

        ObjectKeyValueChild(Object k, Object v) {
            this.b = k;
            this.o = v;
        }
    }
}

