/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;
import org.maachang.mimdb.MimdbDatabase;
import org.maachang.mimdb.core.util.AtomicNumber32;
import org.maachang.mimdb.server.ReceiveMaintenanceServer;

class AcceptMaintenanceServer
extends Thread {
    private ServerSocket server;
    private ReceiveMaintenanceServer[] recvList;
    private final AtomicNumber32 stopFlag = new AtomicNumber32(0);
    private int recvSeq = 0;

    private AcceptMaintenanceServer() {
    }

    public AcceptMaintenanceServer(Map<String, MimdbDatabase> map, String bind, int port, int backlog) throws Exception {
        int len = (int)((double)backlog * 1.5);
        this.recvList = new ReceiveMaintenanceServer[len];
        for (int i = 0; i < len; ++i) {
            this.recvList[i] = new ReceiveMaintenanceServer(map);
        }
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "0");
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.configureBlocking(true);
        ServerSocket soc = channel.socket();
        soc.setReuseAddress(true);
        soc.setSoTimeout(1000);
        if (bind == null) {
            soc.bind(new InetSocketAddress(port), backlog);
        } else {
            soc.bind(new InetSocketAddress(InetAddress.getByName(bind), port), backlog);
        }
        this.server = soc;
        this.stopFlag.set(1);
        this.setDaemon(true);
        this.start();
    }

    public void stopThread() {
        this.stopFlag.set(0);
        if (this.recvList != null) {
            int len = this.recvList.length;
            for (int i = 0; i < len; ++i) {
                this.recvList[i].stopThread();
            }
            this.recvList = null;
        }
    }

    public boolean isThread() {
        return this.stopFlag.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block30: {
            s = null;
            cnt = 0;
            len = this.recvList.length;
            block26: while (true) {
                while (true) {
                    if (this.stopFlag.get() == 0) break block30;
                    s = this.server.accept();
                    if (s == null) continue;
                    if (this.stopFlag.get() == 0) break block30;
                    cnt = 0;
                    while (cnt++ < len) {
                        if (this.recvSeq >= len) {
                            this.recvSeq = 0;
                        }
                        if (!this.recvList[this.recvSeq++].setSocket(s)) continue;
                        s = null;
                        break;
                    }
                    if (s == null) continue;
                    try {
                        s.close();
                        continue block26;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {}
                    continue block26;
                    finally {
                        if (s != null) ** break;
                        continue;
                        try {
                            s.close();
                            continue block26;
                        }
                        catch (Exception e) {}
                    }
                    break;
                }
            }
            finally {
                this.stopThread();
            }
        }
    }
}

