package org.maachang.mimdb.core;

/**
 * 検索中データを示す情報.
 * 
 * @version 2013/10/11
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface MimdbMiddleSearch extends MimdbBase {
    
    /**
     * 情報クリア.
     */
    public void clear() ;
    
    /**
     * 行データをセット.
     * @param no 行データを設定します.
     */
    public void add( int no ) ;
    
    /**
     * 行データをセット.
     * @param no 行データ群を設定します.
     */
    public void addArray( int[] no ) ;
    
    /**
     * 行データをOFF.
     * @param no 行番号を設定します.
     */
    public void off( int no ) ;
    
    /**
     * 行データをOFF.
     * @param no 行番号群を設定します.
     */
    public void offArray( int[] no ) ;
    
    /**
     * 行データを全てONにセット.
     */
    public void all() ;
    
    /**
     * 行データをマージOrセット.
     * @param search マージ対象の検索データを設定します.
     */
    public void or( MimdbMiddleSearch search ) ;
    
    /**
     * 行データをマージAndセット.
     * @param search マージ対象の検索データを設定します.
     */
    public void and( MimdbMiddleSearch search ) ;
    
    /**
     * 行データオブジェクトを取得.
     * @param out 行データオブジェクトが返却されます.
     * @param off 対象のオフセット値を設定します.
     * @return int 有効情報数が返却されます.
     */
    public int getResultArray( ResultArray[] out ) ;
    
    /**
     * 行データオブジェクトを取得.
     * @param out 行データオブジェクトが返却されます.
     * @param off 対象のオフセット値を設定します.
     * @return int 有効情報数が返却されます.
     */
    public int getResultArray( ResultArray[] out,int off ) ;
    
    /**
     * データ数を取得.
     * @return int データ数が返却されます.
     */
    public int size() ;
    
    /**
     * このオブジェクトがAND属性かチェック.
     * @return boolean [true]の場合、AND属性です.
     */
    public boolean isAnd() ;
}
