package org.maachang.mimdb.core ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * プライマリーキーの結果情報.
 * 
 * @version 2013/10/10
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
class PrimaryResultRowImpl extends MimdbResultRow {
    
    /** 対象データ. **/
    MimdbRow row ;
    
    /**
     * コンストラクタ.
     */
    public PrimaryResultRowImpl( MimdbRow row ) {
        this.row = row ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        row = null ;
    }
    
    /**
     * 更新IDを取得.
     * @return long 更新IDが返却されます.
     */
    public long getDbId() {
        return row.dbId ;
    }
    
    /**
     * テーブル名の取得.
     * @return String テーブル名が返却されます.
     */
    public String getName() {
        return row.getTableName() ;
    }
    
    /**
     * テーブル情報の取得.
     * @return BaseTable テーブル情報が返却されます.
     */
    public BaseTable getTable() {
        return row.getTable() ;
    }
    
    /**
     * 対象の行番号を取得.
     * @return int 行番号が返却されます.
     */
    public int getLineNo() {
        return 0 ;
    }
    
    /**
     * ソート順の取得.
     * @return boolean [true]の場合、降順ソートです.
     */
    public boolean isDesc() {
        return false ;
    }
    
    /**
     * カラム項番で情報を取得.
     * @param n 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( int n ) {
        return row.getValue( n ) ;
    }
    
    /*********************** 以下 Map定義 ***********************/
    
    public void putAll(Map toMerge) {
        // 処理なし.
    }
    public boolean containsValue(Object value) {
        int len = row.getTable().columnLength ;
        Object[] values = row.getValues() ;
        if( value == null ) {
            for( int i = 0 ; i < len ; i ++ ) {
                if( values[ i ] == null ) {
                    return true ;
                }
            }
        }
        else {
            for( int i = 0 ; i < len ; i ++ ) {
                if( value.equals( values[ i ] ) ) {
                    return true ;
                }
            }
        }
        return false ;
    }
    public Set entrySet() {
        // 処理なし.
        return null ;
    }
    public Collection values() {
        int len = row.getTable().columnLength ;
        List<Object> ret = new ArrayList<Object>( len ) ;
        Object[] values = row.getValues() ;
        for( int i = 0 ; i < len ; i ++ ) {
            ret.add( values[ i ] ) ;
        }
        return ret ;
    }
    public Object put(Object name, Object value) {
        // 処理なし.
        return null ;
    }
    public boolean containsKey(Object key) {
        if( key instanceof String ) {
            return row.getTable().columnsMap.containsKey( ((String)key).trim().toLowerCase() ) ;
        }
        else if( key instanceof Number ) {
            int n = ((Number)key).intValue() ;
            return ( n >= 0 && n < row.getTable().columnLength ) ;
        }
        return false ;
    }
    public Object get(Object key) {
        if( key instanceof String ) {
            Integer n = row.getTable().columnsMap.get( ((String)key).trim().toLowerCase() ) ;
            if( n != null ) {
                return row.getValue( n ) ;
            }
        }
        else if( key instanceof Number ) {
            int n = ((Number)key).intValue() ;
            if( n >= 0 && n < row.getTable().columnLength ) {
                return row.getValue( n ) ;
            }
        }
        return null ;
    }
    public Object remove(Object key) {
        // 処理なし.
        return null ;
    }
    public boolean isEmpty() {
        return false ;
    }
    public Set keySet() {
        Set<Object> ret = new HashSet<Object>() ;
        getAllKey( ret ) ;
        return ret ;
    }
    public int size() {
        return row.getTable().columnLength ;
    }
    public void getAllKey( Set<Object> set ) {
        int len = row.getTable().columnLength ;
        String[] key = row.getTable().columns ;
        for( int i = 0 ; i < len ; i ++ ) {
            set.add( key[ i ] ) ;
        }
    }
    public void getAllValues( Set<Object> set ) {
        int len = row.getTable().columnLength ;
        Object[] values = row.getValues() ;
        for( int i = 0 ; i < len ; i ++ ) {
            set.add( values[ i ] ) ;
        }
    }
    public String toString() {
        int len = row.getTable().columnLength ;
        StringBuilder buf = new StringBuilder() ;
        String[] key = row.getTable().columns ;
        Object[] values = row.getValues() ;
        buf.append( "{" ) ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                buf.append( "," ) ;
            }
            if( values[ i ] instanceof String ) {
                buf.append( key[ i ] ).append( ":\"" ).append( values[ i ] ).append( "\"" ) ;
            }
            else {
                buf.append( key[ i ] ).append( ":" ).append( values[ i ] ) ;
            }
        }
        return buf.append( "}" ).toString() ;
    }
}
