package org.maachang.mimdb.core;

/**
 * テーブル管理.
 * 
 * @version 2014/01/17
 * @author masahito suzuki
 * @since MasterInMemDB 1.02
 */
public interface TableManager {
    
    /**
     * オブジェクトを破棄.
     */
    public void destroy() ;
    
    /**
     * テーブルが登録されているかチェック.
     * @param name 対象のテーブルを設定します.
     * @return boolean [true]の場合、登録されています.
     */
    public boolean isTable( String name ) ;
    
    /**
     * 登録テーブル情報の取得.
     * @param name テーブル名を設定します.
     * @return BaseTable テーブル情報が返されます.
     */
    public BaseTable get( String name ) ;
    
    /**
     * 登録テーブル数を取得.
     * @return int 登録されているテーブル数が返却されます.
     */
    public int size() ;
    
    /**
     * 登録テーブル一覧を取得.
     * @return String[] 登録されているテーブル名一覧が返却されます.
     */
    public String[] getTables() ;
    
}
