package org.maachang.mimdb.core.impl ;

import java.io.OutputStream;
import java.util.Arrays;

import org.maachang.mimdb.core.util.ObjectBinary;

/**
 * 数値一致確認オブジェクト.
 * 
 * @version 2013/10/27
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public final class EqualsNoList {
    private final int[] list ;
    private final int[] src ;
    
    /** コンストラクタ. **/
    public EqualsNoList() {
        list = null ;
        src = null ;
    }
    
    /**
     * コンストラクタ.
     * @param n 対象の配列を設定します.
     */
    public EqualsNoList( final int[] n ) {
        int len = n.length ;
        list = new int[ len ] ;
        System.arraycopy( n,0,list,0,len ) ;
        Arrays.sort( list ) ;
        src = n ;
    }
    
    /**
     * 元情報の取得.
     * @param no 対象項番を設定します.
     * @return int 元情報が返却されます.
     */
    public int src( final int no ) {
        return src[ no ] ;
    }
    
    /**
     * 元情報配列の取得.
     * @return int[] 元情報配列が返却されます.
     */
    public int[] arrays() {
        return src ;
    }
    
    /**
     * サイズの取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return src.length ;
    }
    
    /**
     * 情報一致チェック.
     * @param o 対象のオブジェクトを設定します.
     * @return boolean [true]の場合、一致しています.
     */
    public boolean equals( final Object o ) {
        if( o instanceof EqualsNoList ) {
            EqualsNoList n = ( EqualsNoList )o ;
            if( n.list.length != list.length ) {
                return false ;
            }
            int len = list.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( src[ i ] != n.src[ i ] ) {
                    return false ;
                }
            }
        }
        return false ;
    }
    
    /**
     * バイナリ変換.
     * @param out 対象のOutputStreamを設定します.
     * @exception Exception 例外.
     */
    public void getOutput( final OutputStream out )
        throws Exception {
        ObjectBinary.encode( out,src ) ;
    }
    
}
