package org.maachang.mimdb.jdbc ;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbIndex;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;

/**
 * Mimdb-JDBC ResultSet.
 * 
 * @version 2013/11/19
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
public class MimdbJdbcResultSet implements java.sql.ResultSet {
    protected MimdbJdbcStatement statement = null ;
    protected MimdbResult result = null ;
    private String name ;
    private boolean wasNullFlag = false ;
    private MimdbResultRow line = null ;
    
    protected MimdbJdbcResultSet( MimdbJdbcStatement st,MimdbResult res ) {
        this.statement = st ;
        this.result = res ;
        this.name = res.getMetaData().getName() ;
    }
    
    protected void finalize() throws Exception {
        close() ;
    }
    
    public void close() throws SQLException {
        if( result != null ) {
            result.clear() ;
            result = null ;
        }
        line = null ;
        wasNullFlag = false ;
    }
    public boolean isClosed() throws SQLException {
        return result == null ;
    }
    
    /** チェック. **/
    protected void check() {
        statement.check() ;
        if( result == null ) {
            throw new MimdbException( "オブジェクトは既にクローズしています" ) ;
        }
    }
    
    public ResultSetMetaData getMetaData() throws SQLException {
        check() ;
        return new MimdbJdbcResultSetMetaData( result ) ;
    }
    public int getType() throws SQLException {
        return TYPE_SCROLL_INSENSITIVE ;
    }
    public Statement getStatement() throws SQLException {
        return statement ;
    }
    public int getHoldability() throws SQLException {
        return HOLD_CURSORS_OVER_COMMIT ;
    }
    
    public boolean absolute(int row) throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            if( row < 0 ) {
                if( row < -1 ) {
                    return result.absolute(
                        result.length()+((row*-1)-1) ) ;
                }
                row = result.length() - 1 ;
            }
            if( result.absolute( row ) ) {
                line = result.get() ;
                return true ;
            }
            return false ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
        return false ;
    }
    public void afterLast() throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            result.absolute( result.length() ) ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
    }
    public void beforeFirst() throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            result.absolute( -1 ) ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
    }
    public boolean first() throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            if( result.first() ) {
                line = result.get() ;
                return true ;
            }
            return false ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
        return false ;
    }
    public boolean last() throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            if( result.last() ) {
                line = result.get() ;
                return true ;
            }
            return false ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
        return false ;
    }
    public boolean next() throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            if( result.next() ) {
                line = result.get() ;
                return true ;
            }
            return false ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
        return false ;
    }
    public boolean previous() throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            if( result.absolute( result.getRow()-1 ) ) {
                line = result.get() ;
                return true ;
            }
            return false ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
        return false ;
    }
    public boolean relative(int rows) throws SQLException {
        check() ;
        try {
            line = null ;
            wasNullFlag = false ;
            if( result.absolute( result.getRow()+rows ) ) {
                line = result.get() ;
                return true ;
            }
            return false ;
        } catch( Exception e ) {
            errorsql( e ) ;
        }
        return false ;
    }
    public int getRow() throws SQLException {
        check() ;
        return result.getRow() ;
    }
    public boolean isAfterLast() throws SQLException {
        check() ;
        return result.getRow() > result.length() ;
    }
    public boolean isBeforeFirst() throws SQLException {
        check() ;
        return result.getRow() < 0 ;
    }
    public boolean isFirst() throws SQLException {
        check() ;
        return result.getRow() == 0 ;
    }
    public boolean isLast() throws SQLException {
        check() ;
        return result.getRow() == result.length() ;
    }
    
    
    public void cancelRowUpdates() throws SQLException {
        check() ;
        // 無視.
    }
    public void clearWarnings() throws SQLException {
        check() ;
        // 無視.
    }
    public void deleteRow() throws SQLException {
        check() ;
        // 無視.
    }
    public int findColumn(String columnLabel) throws SQLException {
        // 無視.
        check() ;
        return -1 ;
    }
    
    public int getConcurrency() throws SQLException {
        return CONCUR_READ_ONLY ;
    }
    public String getCursorName() throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    
    public Array getArray(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Array getArray(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Blob getBlob(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Blob getBlob(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public byte[] getBytes(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public byte[] getBytes(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Clob getClob(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Clob getClob(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public NClob getNClob(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public NClob getNClob(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Ref getRef(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Ref getRef(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public RowId getRowId(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public RowId getRowId(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Object getObject(int columnIndex, Map<String,Class<?>> map) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    public Object getObject(String columnLabel, Map<String,Class<?>> map) throws SQLException {
        errorsql( "サポートされていません" ) ;
        return null ;
    }
    
    public Object getObject(int columnIndex) throws SQLException {
        check() ;
        Object value = getValue( columnIndex-1 ) ;
        return ( value == null ) ?
            null :
            value ;
    }
    public Object getObject(String columnLabel) throws SQLException {
        check() ;
        Object value = getValue( columnLabel ) ;
        return ( value == null ) ?
            null :
            value ;
    }
    
    public boolean getBoolean(int columnIndex) throws SQLException {
        check() ;
        if( isBool( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                false :
                (Boolean)value ;
        }
        errorsql( "Boolean型ではありません:" + columnIndex ) ;
        return false ;
    }
    public boolean getBoolean(String columnLabel) throws SQLException {
        check() ;
        if( isBool( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                false :
                (Boolean)value ;
        }
        errorsql( "Boolean型ではありません:" + columnLabel ) ;
        return false ;
    }
    
    public byte getByte(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).byteValue() ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return 0 ;
    }
    public byte getByte(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).byteValue() ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return 0 ;
    }
    
    public short getShort(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).shortValue() ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return 0 ;
    }
    public short getShort(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).shortValue() ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return 0 ;
    }
    
    public int getInt(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).intValue() ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return 0 ;
    }
    public int getInt(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).intValue() ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return 0 ;
    }
    
    public long getLong(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).longValue() ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return 0 ;
    }
    public long getLong(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).longValue() ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return 0 ;
    }
    
    public float getFloat(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).floatValue() ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return 0 ;
    }
    public float getFloat(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).floatValue() ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return 0 ;
    }
    
    public double getDouble(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).doubleValue() ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return 0 ;
    }
    public double getDouble(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                0 :
                ( (Number)value ).doubleValue() ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return 0 ;
    }
    
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                new BigDecimal( value.toString() ) ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return null ;
    }
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        check() ;
        if( isNumber( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                new BigDecimal( new BigInteger( String.valueOf( ((Number)value).intValue() ) ),scale ) ;
        }
        errorsql( "数字型ではありません:" + columnIndex ) ;
        return null ;
    }
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                new BigDecimal( value.toString() ) ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return null ;
    }
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        check() ;
        if( isNumber( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                new BigDecimal( new BigInteger( String.valueOf( ((Number)value).intValue() ) ),scale ) ;
        }
        errorsql( "数字型ではありません:" + columnLabel ) ;
        return null ;
    }
    
    public Date getDate(int columnIndex) throws SQLException {
        check() ;
        if( isDate( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (Date)convertDate( MimdbIndex.COLUMN_DATE,(java.util.Date)value,null ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnIndex ) ;
        return null ;
    }
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        check() ;
        if( isDate( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (Date)convertDate( MimdbIndex.COLUMN_DATE,(java.util.Date)value,cal ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnIndex ) ;
        return null ;
    }
    public Date getDate(String columnLabel) throws SQLException {
        check() ;
        if( isDate( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (Date)convertDate( MimdbIndex.COLUMN_DATE,(java.util.Date)value,null ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnLabel ) ;
        return null ;
    }
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        check() ;
        if( isDate( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (Date)convertDate( MimdbIndex.COLUMN_DATE,(java.util.Date)value,cal ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnLabel ) ;
        return null ;
    }
    
    public Time getTime(int columnIndex) throws SQLException {
        check() ;
        if( isDate( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (Time)convertDate( MimdbIndex.COLUMN_TIME,(java.util.Date)value,null ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnIndex ) ;
        return null ;
    }
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        check() ;
        if( isDate( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (Time)convertDate( MimdbIndex.COLUMN_TIME,(java.util.Date)value,cal ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnIndex ) ;
        return null ;
    }
    public Time getTime(String columnLabel) throws SQLException {
        check() ;
        if( isDate( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (Time)convertDate( MimdbIndex.COLUMN_TIME,(java.util.Date)value,null ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnLabel ) ;
        return null ;
    }
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        check() ;
        if( isDate( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (Time)convertDate( MimdbIndex.COLUMN_TIME,(java.util.Date)value,cal ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnLabel ) ;
        return null ;
    }
    
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        check() ;
        if( isDate( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (Timestamp)convertDate( MimdbIndex.COLUMN_TIMESTAMP,(java.util.Date)value,null ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnIndex ) ;
        return null ;
    }
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        check() ;
        if( isDate( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (Timestamp)convertDate( MimdbIndex.COLUMN_TIMESTAMP,(java.util.Date)value,cal ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnIndex ) ;
        return null ;
    }
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        check() ;
        if( isDate( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (Timestamp)convertDate( MimdbIndex.COLUMN_TIMESTAMP,(java.util.Date)value,null ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnLabel ) ;
        return null ;
    }
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        check() ;
        if( isDate( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (Timestamp)convertDate( MimdbIndex.COLUMN_TIMESTAMP,(java.util.Date)value,cal ) ;
        }
        errorsql( "日付/時間型ではありません:" + columnLabel ) ;
        return null ;
    }
    
    public String getString(int columnIndex) throws SQLException {
        check() ;
        if( isString( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (String)value ;
        }
        errorsql( "String型ではありません:" + columnIndex ) ;
        return null ;
    }
    public String getString(String columnLabel) throws SQLException {
        check() ;
        if( isString( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (String)value ;
        }
        errorsql( "String型ではありません:" + columnLabel ) ;
        return null ;
    }
    public String getNString(int columnIndex) throws SQLException {
        check() ;
        if( isString( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            return ( value == null ) ?
                null :
                (String)value ;
        }
        errorsql( "String型ではありません:" + columnIndex ) ;
        return null ;
    }
    public String getNString(String columnLabel) throws SQLException {
        check() ;
        if( isString( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            return ( value == null ) ?
                null :
                (String)value ;
        }
        errorsql( "String型ではありません:" + columnLabel ) ;
        return null ;
    }
    public URL getURL(int columnIndex) throws SQLException {
        check() ;
        if( isString( columnIndex-1 ) ) {
            Object value = getValue( columnIndex-1 ) ;
            try {
                return ( value == null ) ?
                    null :
                    new URL( (String)value ) ;
            } catch( Exception e ) {
                errorsql( e ) ;
            }
        }
        errorsql( "String型ではありません:" + columnIndex ) ;
        return null ;
    }
    public URL getURL(String columnLabel) throws SQLException {
        check() ;
        if( isString( columnLabel ) ) {
            Object value = getValue( columnLabel ) ;
            try {
                return ( value == null ) ?
                    null :
                    new URL( (String)value ) ;
            } catch( Exception e ) {
                errorsql( e ) ;
            }
        }
        errorsql( "String型ではありません:" + columnLabel ) ;
        return null ;
    }
    
    public SQLWarning getWarnings() throws SQLException {
        check() ;
        return null ;
    }
    public void insertRow() throws SQLException {
        check() ;
        // 無視.
    }
    public void moveToCurrentRow() throws SQLException {
        check() ;
        // 無視.
    }
    public void moveToInsertRow() throws SQLException {
        check() ;
        // 無視.
    }
    public void refreshRow() throws SQLException {
        check() ;
        // 無視.
    }
    public boolean rowDeleted() throws SQLException {
        check() ;
        return false ;
        // 無視.
    }
    public boolean rowInserted() throws SQLException {
        check() ;
        return false ;
        // 無視.
    }
    public boolean rowUpdated() throws SQLException {
        check() ;
        return false ;
        // 無視.
    }
    public void setFetchDirection(int direction) throws SQLException {
        check() ;
        // 無視.
    }
    public void setFetchSize(int rows) throws SQLException {
        check() ;
        if( rows <= 0 ) {
            rows = 1 ;
        }
        result.setFetchSize( rows ) ;
        // 無視.
    }
    public int getFetchDirection() throws SQLException {
        check() ;
        return FETCH_FORWARD  ;
    }
    public int getFetchSize() throws SQLException {
        check() ;
        return result.getFetchSize() ;
    }
    public void updateRow() throws SQLException {
        check() ;
        // 無視.
    }
    public boolean wasNull() throws SQLException {
        check() ;
        return wasNullFlag ;
    }
    
    public void updateArray(int columnIndex, Array x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateArray(String columnLabel, Array x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateByte(int columnIndex, byte x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateByte(String columnLabel, byte x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateDate(int columnIndex, Date x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateDate(String columnLabel, Date x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateDouble(int columnIndex, double x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateDouble(String columnLabel, double x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateFloat(int columnIndex, float x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateFloat(String columnLabel, float x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateInt(int columnIndex, int x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateInt(String columnLabel, int x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateLong(int columnIndex, long x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateLong(String columnLabel, long x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNString(int columnIndex, String nString) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNString(String columnLabel, String nString) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNull(int columnIndex) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateNull(String columnLabel) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateObject(int columnIndex, Object x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateObject(String columnLabel, Object x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateShort(int columnIndex, short x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateShort(String columnLabel, short x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateString(int columnIndex, String x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateString(String columnLabel, String x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateTime(int columnIndex, Time x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateTime(String columnLabel, Time x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        errorsql( "サポートされていません" ) ;
    }
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false ;
    }
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null ;
    }
    
    // エラーメッセージ出力.
    private final void errorsql( String msg ) throws SQLException {
        throw new SQLException( "エラー:" + name + " " + msg ) ;
    }
    // エラーメッセージ出力.
    private final void errorsql( Exception e ) throws SQLException {
        throw new SQLException( "エラー:" + name,e ) ;
    }
    // エラーメッセージ出力.
    //private final void errorsql( String msg,Exception e ) throws SQLException {
    //    throw new SQLException( "エラー::" + name + " " + msg,e ) ;
    //}
    
    // 現在の行情報のカラム条件を取得.
    private final Object getValue( int no )
        throws SQLException {
        if( line == null ) {
            errorsql( "情報が存在しません" ) ;
        }
        if( line.getValue( no ) == null ) {
            wasNullFlag = true ;
            return null ;
        }
        wasNullFlag = false ;
        return line.getValue( no ) ;
    }
    
    // 現在の行情報のカラム条件を取得.
    private final Object getValue( String name )
        throws SQLException {
        if( line == null ) {
            errorsql( "情報が存在しません" ) ;
        }
        if( line.get( name ) == null ) {
            wasNullFlag = true ;
            return null ;
        }
        wasNullFlag = false ;
        return line.get( name ) ;
    }
    
    // 数字かチェック.
    private final boolean isNumber( int no ) {
        switch( result.getMetaData().getColumnType( no ) ) {
            case MimdbIndex.COLUMN_INT :
            case MimdbIndex.COLUMN_LONG :
            case MimdbIndex.COLUMN_FLOAT :
                return true ;
        }
        return false ;
    }
    
    // 数字かチェック.
    private final boolean isNumber( String column ) {
        switch( result.getMetaData().getColumnType( column ) ) {
            case MimdbIndex.COLUMN_INT :
            case MimdbIndex.COLUMN_LONG :
            case MimdbIndex.COLUMN_FLOAT :
                return true ;
        }
        return false ;
    }
    
    // 文字かチェック.
    private final boolean isString( int no ) {
        return result.getMetaData().getColumnType( no ) ==
            MimdbIndex.COLUMN_STRING ;
    }
    
    // 文字かチェック.
    private final boolean isString( String column ) {
        return result.getMetaData().getColumnType( column ) ==
            MimdbIndex.COLUMN_STRING ;
    }
    
    // Booleanかチェック.
    private final boolean isBool( int no ) {
        return result.getMetaData().getColumnType( no ) ==
            MimdbIndex.COLUMN_BOOL ;
    }
    
    // Booleanかチェック.
    private final boolean isBool( String column ) {
        return result.getMetaData().getColumnType( column ) ==
            MimdbIndex.COLUMN_BOOL ;
    }
    
    // 日付／時間かチェック.
    private final boolean isDate( int no ) {
        switch( result.getMetaData().getColumnType( no ) ) {
            case MimdbIndex.COLUMN_DATE :
            case MimdbIndex.COLUMN_TIME :
            case MimdbIndex.COLUMN_TIMESTAMP :
                return true ;
        }
        return false ;
    }
    
    // 日付／時間かチェック.
    private final boolean isDate( String column ) {
        switch( result.getMetaData().getColumnType( column ) ) {
            case MimdbIndex.COLUMN_DATE :
            case MimdbIndex.COLUMN_TIME :
            case MimdbIndex.COLUMN_TIMESTAMP :
                return true ;
        }
        return false ;
    }
    
    // 日付／時間変換.
    protected static final java.util.Date convertDate( int mode,java.util.Date date,Calendar calendar ) {
        if( calendar == null ) {
            switch( mode ) {
                case MimdbIndex.COLUMN_DATE :
                    return new java.sql.Date( date.getTime() ) ;
                case MimdbIndex.COLUMN_TIME :
                    return new java.sql.Time( date.getTime() ) ;
                case MimdbIndex.COLUMN_TIMESTAMP :
                    return new java.sql.Timestamp( date.getTime() ) ;
            }
        }
        calendar.setTimeInMillis( date.getTime() ) ;
        switch( mode ) {
            case MimdbIndex.COLUMN_DATE :
                return new java.sql.Date( calendar.get( Calendar.YEAR ),
                    calendar.get( Calendar.MONTH ),calendar.get( Calendar.DATE ) ) ;
            case MimdbIndex.COLUMN_TIME :
                return new java.sql.Time( calendar.get( Calendar.HOUR_OF_DAY ),
                    calendar.get( Calendar.MINUTE ),calendar.get( Calendar.SECOND ) ) ;
            case MimdbIndex.COLUMN_TIMESTAMP :
                return new java.sql.Timestamp( calendar.get( Calendar.YEAR ),
                    calendar.get( Calendar.MONTH ),calendar.get( Calendar.DATE ),
                    calendar.get( Calendar.HOUR_OF_DAY ),calendar.get( Calendar.MINUTE ),
                    calendar.get( Calendar.SECOND ),0 ) ;
        }
        return null ;
    }

    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }

    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        // TODO 自動生成されたメソッド・スタブ
        return null;
    }
}

