/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.leveldb.JniIO;
import org.maachang.leveldb.jni;

public final class JniBuffer
extends OutputStream {
    protected static final int CLEAR_BY_MAX_BUFFER = 65535;
    private long address = 0L;
    private int length = 0;
    private int position = 0;

    protected final void finalize() throws Exception {
        this.destroy();
    }

    protected final void set(long addr, int len, int pos) {
        if (this.address != 0L) {
            jni.free(this.address);
            this.address = 0L;
            this.length = 0;
            this.position = 0;
        }
        if (addr != 0L) {
            this.address = addr;
            this.length = len;
            this.position = pos;
        } else {
            this.length = 0;
            this.position = 0;
        }
    }

    protected final void recreate(boolean copy, int newLen) {
        if (this.length > newLen) {
            return;
        }
        newLen = newLen < 8 ? 8 : (newLen += newLen >> 1);
        if (copy) {
            if (this.address != 0L) {
                long t = jni.malloc(newLen);
                jni.memcpy(t, this.address, this.length);
                jni.free(this.address);
                this.address = t;
            } else {
                this.address = jni.malloc(newLen);
            }
        } else {
            if (this.address != 0L) {
                jni.free(this.address);
            }
            this.address = jni.malloc(newLen);
        }
        this.length = newLen;
    }

    public final JniBuffer destroy() {
        if (this.address != 0L) {
            jni.free(this.address);
            this.address = 0L;
            this.length = 0;
            this.position = 0;
        }
        return this;
    }

    public final JniBuffer clear(int len) {
        if (this.address != 0L) {
            if (this.length > len) {
                this.position = 0;
                return this;
            }
            jni.free(this.address);
        }
        this.address = jni.malloc(len);
        this.length = len;
        this.position = 0;
        return this;
    }

    public final JniBuffer clear() {
        return this.clear(false);
    }

    public final JniBuffer clear(boolean mode) {
        if (this.address != 0L) {
            if (mode && this.length > 65535) {
                this.destroy();
                this.address = jni.malloc(65535);
                this.length = 65535;
            } else {
                this.position = 0;
            }
        }
        return this;
    }

    public final long address() {
        return this.address;
    }

    public final int length() {
        return this.length;
    }

    public final int position() {
        return this.position;
    }

    public final void position(int p) {
        if (this.length <= p) {
            this.recreate(true, p + 1);
        }
        this.position = p;
    }

    private final void _write(boolean copy, int b) {
        if (this.length <= this.position) {
            this.recreate(copy, this.position + 1);
        }
        JniIO.put(this.address, this.position, (byte)b);
        ++this.position;
    }

    private final void _write(boolean copy, byte[] b) {
        this._write(copy, b, 0, b.length);
    }

    private final void _write(boolean copy, byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.length <= this.position + len) {
            this.recreate(copy, this.position + len + 1);
        }
        jni.putBinary(this.address + (long)this.position, b, off, len);
        this.position += len;
    }

    @Override
    public final void close() throws IOException {
        this.clear();
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public final void write(int b) throws IOException {
        this._write(true, b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this._write(true, b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this._write(true, b, off, len);
    }

    public final JniBuffer set(int value) {
        this.position = 0;
        this._write(false, value);
        return this;
    }

    public final JniBuffer set(byte value) {
        return this.set((int)value);
    }

    public final Byte get() {
        if (this.position == 0) {
            return null;
        }
        return JniIO.get(this.address, 0);
    }

    public final JniBuffer setBinary(byte[] value) {
        return this.setBinary(value, 0, value.length);
    }

    public final JniBuffer setBinary(byte[] value, int len) {
        return this.setBinary(value, 0, len);
    }

    public final JniBuffer setBinary(byte[] value, int off, int len) {
        this.position = 0;
        this._write(false, value, off, len);
        return this;
    }

    public final byte[] getBinary() {
        if (this.position == 0) {
            return null;
        }
        byte[] ret = new byte[this.position];
        jni.getBinary(this.address, ret, 0, this.position);
        return ret;
    }

    public final int getBinary(byte[] value) {
        return this.getBinary(value, 0, value.length);
    }

    public final int getBinary(byte[] value, int len) {
        return this.getBinary(value, 0, len);
    }

    public final int getBinary(byte[] value, int off, int len) {
        if (this.position < off + len) {
            len = this.position - off;
        }
        if (value.length < len) {
            len = value.length;
        }
        if (len == 0 || this.position == 0) {
            return -1;
        }
        jni.getBinary(this.address, value, off, len);
        return len;
    }

    public final JniBuffer setString(String string) throws Exception {
        this.position = 0;
        this._write(false, string.getBytes("UTF8"));
        return this;
    }

    public final JniBuffer setString(String string, int off, int len) throws Exception {
        this.position = 0;
        this._write(false, string.substring(off, off + len).getBytes("UTF8"));
        return this;
    }

    public final String getString() throws Exception {
        if (this.position == 0) {
            return null;
        }
        byte[] ret = new byte[this.position];
        jni.getBinary(this.address, ret, 0, this.position);
        return new String(ret, "UTF8");
    }

    public final String getString(int len) throws Exception {
        if (len > this.position) {
            len = this.position;
        }
        if (len == 0 || this.position == 0) {
            return null;
        }
        byte[] ret = new byte[len];
        jni.getBinary(this.address, ret, 0, len);
        return new String(ret, "UTF8");
    }

    public final JniBuffer setBoolean(boolean value) {
        this.position = 0;
        this.recreate(false, 1);
        JniIO.put(this.address, 0, (byte)(value ? 1 : 0));
        this.position = 1;
        return this;
    }

    public final Boolean getBoolean() {
        if (this.position == 0) {
            return null;
        }
        if (JniIO.get(this.address, 0) == 1) {
            return true;
        }
        return false;
    }

    public final JniBuffer setShort(short value) {
        this.position = 0;
        this.recreate(false, 2);
        JniIO.putShort(this.address, 0, value);
        this.position = 2;
        return this;
    }

    public Short getShort() {
        if (this.position < 2) {
            return null;
        }
        return JniIO.getShort(this.address, 0);
    }

    public final JniBuffer setInt(int value) {
        this.position = 0;
        this.recreate(false, 4);
        JniIO.putInt(this.address, 0, value);
        this.position = 4;
        return this;
    }

    public final Integer getInt() {
        if (this.position < 4) {
            return null;
        }
        return JniIO.getInt(this.address, 0);
    }

    public final JniBuffer setLong(long value) {
        this.position = 0;
        this.recreate(false, 8);
        JniIO.putLong(this.address, 0, value);
        this.position = 8;
        return this;
    }

    public final Long getLong() {
        if (this.position < 8) {
            return null;
        }
        return JniIO.getLong(this.address, 0);
    }

    public final JniBuffer setFloat(float value) {
        this.position = 0;
        this.recreate(false, 4);
        JniIO.putFloat(this.address, 0, value);
        this.position = 4;
        return this;
    }

    public final Float getFloat() {
        if (this.position < 4) {
            return null;
        }
        return Float.valueOf(JniIO.getFloat(this.address, 0));
    }

    public final JniBuffer setDouble(double value) {
        this.position = 0;
        this.recreate(false, 8);
        JniIO.putDouble(this.address, 0, value);
        this.position = 8;
        return this;
    }

    public final Double getDouble() {
        if (this.position < 8) {
            return null;
        }
        return JniIO.getDouble(this.address, 0);
    }

    protected final JniBuffer setJniChar(String string) {
        this.position = 0;
        this._write(false, string.getBytes());
        this._write(true, 0);
        return this;
    }

    protected final JniBuffer setJniChar(String string, int off, int len) {
        this.position = 0;
        this._write(false, string.substring(off, off + len).getBytes());
        this._write(true, 0);
        return this;
    }

    public final String toString() {
        return "length:" + this.length + " position:" + this.position;
    }
}

