/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.leveldb.LevelMap;
import org.maachang.leveldb.Leveldb;

public final class LeveldbFactory {
    protected static final LeveldbFactory SNGL = new LeveldbFactory();
    protected String baseFolder = "";
    protected final Map<String, LevelMap> factory = new ConcurrentHashMap<String, LevelMap>();
    protected final Object sync = new Object();

    protected LeveldbFactory() {
    }

    public static final LeveldbFactory getInstance() {
        return SNGL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBaseFolder(String folder) {
        File f;
        if (folder == null || (folder = folder.trim()).length() == 0) {
            this.baseFolder = "";
        }
        if (!(f = new File(folder)).exists() || !f.isDirectory()) {
            f.mkdirs();
        }
        if (!(folder = LeveldbFactory.cs(folder, "\\", "/")).endsWith("/")) {
            folder = String.valueOf(folder) + "/";
        }
        Object object = this.sync;
        synchronized (object) {
            this.baseFolder = folder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getBaseFolder() {
        Object object = this.sync;
        synchronized (object) {
            return this.baseFolder;
        }
    }

    private static final String cs(String src, String s, String d) {
        char t = s.charAt(0);
        int len = src.length();
        int lenS = s.length();
        StringBuilder buf = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            if (src.charAt(i) == t) {
                int j = i;
                int k = 0;
                while (++k < lenS && ++j < len && src.charAt(j) == s.charAt(k)) {
                }
                if (k >= lenS) {
                    buf.append(d);
                    i += lenS - 1;
                } else {
                    buf.append(t);
                }
            } else {
                buf.append(src.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public final void closeAll() {
        Iterator<String> it = this.factory.keySet().iterator();
        while (it.hasNext()) {
            LevelMap m = this.factory.get(it.next());
            if (m == null) continue;
            m.close();
        }
        this.factory.clear();
    }

    public final void close(String name) {
        LevelMap m = this.factory.remove(name);
        if (m != null) {
            m.close();
        }
    }

    public final LevelMap get(String name) throws Exception {
        return this.get(name, -1, -1, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LevelMap get(String name, int write_buffer_size, int max_open_files, int block_size, int block_restart_interval) throws Exception {
        if (name == null || name.length() == 0) {
            return null;
        }
        LevelMap map = this.factory.get(name);
        if (map == null) {
            Object object = this.sync;
            synchronized (object) {
                map = this.factory.get(name);
                if (map == null) {
                    map = new LevelMap(String.valueOf(this.baseFolder) + name, write_buffer_size, max_open_files, block_size, block_restart_interval);
                    this.factory.put(name, map);
                }
            }
        }
        return map;
    }

    public final void remove(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        this.factory.remove(name);
    }

    public final boolean containsKey(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return this.factory.containsKey(name);
    }

    public final Leveldb getLeveldb(String name) throws Exception {
        LevelMap m = this.get(name, -1, -1, -1, -1);
        if (m != null) {
            return m.leveldb;
        }
        return null;
    }

    public final Leveldb getLeveldb(String name, int write_buffer_size, int max_open_files, int block_size, int block_restart_interval) throws Exception {
        LevelMap m = this.get(name, write_buffer_size, max_open_files, block_size, block_restart_interval);
        if (m != null) {
            return m.leveldb;
        }
        return null;
    }

    public final List<String> names() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<String> it = this.factory.keySet().iterator();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public final int size() {
        return this.factory.size();
    }
}

