/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.LeveldbException;
import org.maachang.leveldb.SnappyCore;

public final class Snappy {
    public static final int compress(JniBuffer out, JniBuffer src) {
        int srcLen = src.position();
        if (srcLen == 0) {
            throw new LeveldbException("\u5727\u7e2e\u5bfe\u8c61\u306e\u6761\u4ef6\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int len = SnappyCore.calcMaxCompressLength(srcLen);
        if (out.length() < len) {
            out.clear(len);
        } else {
            out.clear(false);
        }
        int ret = SnappyCore.compress(src.address(), srcLen, out.address());
        out.position(ret);
        return ret;
    }

    public static final int decompress(JniBuffer out, JniBuffer src) {
        int srcLen = src.position();
        if (srcLen == 0) {
            throw new LeveldbException("\u89e3\u51cd\u5bfe\u8c61\u306e\u6761\u4ef6\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int len = SnappyCore.decompressLength(src.address(), 0, srcLen);
        if (out.length() < len) {
            out.clear(len);
        } else {
            out.clear(false);
        }
        int ret = SnappyCore.decompress(src.address(), srcLen, out.address());
        out.position(ret);
        return ret;
    }
}

