#ifndef _JAVA_LEVEL_DB_INCLUDE_H_
#define _JAVA_LEVEL_DB_INCLUDE_H_

#include <jni.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Leveldbj. **/
void java_leveldb_destroy( jlong name,jint write_buffer_size,
    jint max_open_files,jint block_size,jint block_restart_interval ) ;

/** Leveldb. **/
void java_leveldb_repair( jlong name,jint write_buffer_size,
    jint max_open_files,jint block_size,jint block_restart_interval ) ;

/** LeveldbI[v. **/
jlong java_leveldb_open( jlong name,jint write_buffer_size,
    jint max_open_files,jint block_size,jint block_restart_interval ) ;

/** LeveldbN[Y. **/
void java_leveldb_close( jlong db ) ;

/** LeveldbvfZbg. **/
jint java_leveldb_put( jlong db, jlong key, jint kLen, jlong value , jint vlen ) ;

/** Leveldbvf擾. **/
jint java_leveldb_get( JNIEnv* env, jlong db , jlong key, jint len, jlongArray buf, jint bufLen ) ;

/** Leveldbvf폜. **/
jint java_leveldb_remove( jlong db, jlong key, jint len ) ;

/** LeveldbԎ擾. **/
jint java_leveldb_property( JNIEnv* env, jlong db , jlong cmd, jint len, jlongArray buf, jint bufLen ) ;

/** Iterator쐬. **/
jlong java_leveldb_iterator( jlong db ) ;

/** IteratorN[Y. **/
void java_leveldb_itr_delete( jlong itr ) ;

/** Iterator擪Ɉړ. **/
void java_leveldb_itr_first( jlong itr ) ;

/** IteratorŌɈړ. **/
void java_leveldb_itr_last( jlong itr ) ;

/** IteratorV[NʒuɈړ. **/
void java_leveldb_itr_seek( jlong itr, jlong key,jint len ) ;

/** Iterator݈ʒuJ[\̏񑶍݊mF. **/
jint java_leveldb_itr_valid( jlong itr ) ;

/** IteratorJ[\Ɉړ. **/
void java_leveldb_itr_next( jlong itr ) ;

/** IteratorJ[\ʒuKey擾. **/
jint java_leveldb_itr_key( JNIEnv* env, jlong itr , jlongArray out, jint bufLen ) ;

/** IteratorJ[\ʒuValue擾. **/
jint java_leveldb_itr_value( JNIEnv* env, jlong itr, jlongArray out, jint bufLen ) ;


/** WriteBatch𐶐. **/
jlong java_leveldb_wb_create() ;

/** WriteBatchj. **/
void java_leveldb_wb_destroy( jlong wb ) ;

/** WriteBatchɏZbg. **/
void java_leveldb_wb_put( jlong wb, jlong key, jint kLen, jlong value , jint vLen ) ;

/** WriteBatchɏ폜. **/
void java_leveldb_wb_remove( jlong wb, jlong key, jint len ) ;

/** WriteBatchDBɔf. **/
jint java_leveldb_wb_flush( jlong db,jlong wb ) ;


#ifdef __cplusplus
}  /* end extern "C" */
#endif

#endif /** _JAVA_LEVEL_DB_INCLUDE_H_ **/
