package org.seasar.dao.meta;

import java.util.HashMap;
import java.util.Map;

import org.seasar.dao.DaoMetaData;

/**
 * @author higa
 *  
 */
public class DaoMetaDataFactory {

	private static Map daoMetaDataCache_ = new HashMap();

	private DaoMetaDataFactory() {
	}

	public static DaoMetaData getDaoMetaData(Class daoClass) {
		DaoMetaData dmd = (DaoMetaData) daoMetaDataCache_.get(daoClass
				.getName());
		if (dmd != null) {
			return dmd;
		}
		synchronized (DaoMetaDataFactory.class) {
			dmd = (DaoMetaData) daoMetaDataCache_.get(daoClass.getName());
			if (dmd != null) {
				return dmd;
			}
			dmd = new DaoMetaDataImpl(daoClass);
			daoMetaDataCache_.put(daoClass.getName(), dmd);
		}
		return dmd;
	}
}