package test.org.seasar.dao.meta;

import junit.framework.TestCase;

import org.seasar.dao.DaoMetaData;
import org.seasar.dao.command.SelectCommand;
import org.seasar.dao.command.UpdateCommand;
import org.seasar.dao.meta.DaoMetaDataImpl;
import org.seasar.extension.jdbc.impl.BeanListResultSetHandler;
import org.seasar.extension.jdbc.impl.BeanResultSetHandler;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;

/**
 * @author higa
 *
 */
public class DaoMetaDataImplTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public DaoMetaDataImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DaoMetaDataImplTest.class);
	}

	public void testSelectBeanList() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class);
		SelectCommand cmd = (SelectCommand) dmd.getSqlCommand("getAllEmployees");
		assertNotNull("1", cmd);
		assertEquals("2", "SELECT * FROM emp", cmd.getSql());
		BeanListResultSetHandler rsh = (BeanListResultSetHandler) cmd.getResultSetHandler();
		assertEquals("3", Employee.class, rsh.getBeanClass());
	}
	
	public void testSelectBean() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class);
		SelectCommand cmd = (SelectCommand) dmd.getSqlCommand("getEmployee");
		assertNotNull("1", cmd);
		assertEquals("2", BeanResultSetHandler.class, cmd.getResultSetHandler().getClass());
		assertEquals("3", "empno", cmd.getArgNames()[0]);
	}
	
	public void testSelectObject() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class);
		SelectCommand cmd = (SelectCommand) dmd.getSqlCommand("getCount");
		assertNotNull("1", cmd);
		assertEquals("2", ObjectResultSetHandler.class, cmd.getResultSetHandler().getClass());
	}
	
	public void testUpdate() throws Exception {
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeDao.class);
		UpdateCommand cmd = (UpdateCommand) dmd.getSqlCommand("update");
		assertNotNull("1", cmd);
		assertEquals("2", "employee", cmd.getArgNames()[0]);
	}
}