/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers.soap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.HandlerChainImpl;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.session.Session;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class SOAPService
extends SimpleTargetedChain {
    private static Log log = LogFactory.getLog((class$org$apache$axis$handlers$soap$SOAPService == null ? (class$org$apache$axis$handlers$soap$SOAPService = SOAPService.class$("org.apache.axis.handlers.soap.SOAPService")) : class$org$apache$axis$handlers$soap$SOAPService).getName());
    private Vector validTransports = null;
    private boolean highFidelityRecording = true;
    private int sendType = 1;
    private ServiceDesc serviceDescription = new JavaServiceDesc();
    private AxisEngine engine;
    private static Hashtable sessions = new Hashtable();
    ArrayList actors = new ArrayList();
    static /* synthetic */ Class class$org$apache$axis$handlers$soap$SOAPService;

    public void addSession(Session session) {
        Vector<Session> v = (Vector<Session>)sessions.get(this.getName());
        if (v == null) {
            v = new Vector<Session>();
            sessions.put(this.getName(), v);
        }
        if (!v.contains(session)) {
            v.add(session);
        }
    }

    public void clearSessions() {
        Vector v = (Vector)sessions.get(this.getName());
        if (v == null) {
            return;
        }
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Session session = (Session)iter.next();
            session.remove(this.getName());
        }
    }

    public ArrayList getServiceActors() {
        return this.actors;
    }

    public ArrayList getActors() {
        ArrayList acts = (ArrayList)this.actors.clone();
        if (this.engine != null) {
            acts.addAll(this.engine.getActorURIs());
        }
        return acts;
    }

    public SOAPService() {
        this.setOptionsLockable(true);
        this.initHashtable();
        this.actors.add("");
    }

    public SOAPService(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        this();
        this.init(reqHandler, new MustUnderstandChecker(), pivHandler, null, respHandler);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.serviceDescription.getTypeMappingRegistry();
    }

    public SOAPService(Handler serviceHandler) {
        this();
        this.init(null, new MustUnderstandChecker(), serviceHandler, null, null);
    }

    public void setEngine(AxisEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullEngine"));
        }
        this.engine = engine;
        ((LockableHashtable)this.options).setParent(engine.getOptions());
        this.getTypeMappingRegistry().delegate(engine.getTypeMappingRegistry());
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public boolean availableFromTransport(String transportName) {
        if (this.validTransports != null) {
            for (int i = 0; i < this.validTransports.size(); ++i) {
                if (!this.validTransports.elementAt(i).equals(transportName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Style getStyle() {
        return this.serviceDescription.getStyle();
    }

    public void setStyle(Style style) {
        this.serviceDescription.setStyle(style);
    }

    public Use getUse() {
        return this.serviceDescription.getUse();
    }

    public void setUse(Use style) {
        this.serviceDescription.setUse(style);
    }

    public ServiceDesc getServiceDescription() {
        return this.serviceDescription;
    }

    public synchronized ServiceDesc getInitializedServiceDesc(MessageContext msgContext) throws AxisFault {
        if (!this.serviceDescription.isInitialized() && this.pivotHandler instanceof BasicProvider) {
            ((BasicProvider)this.pivotHandler).initServiceDesc(this, msgContext);
        }
        return this.serviceDescription;
    }

    public void setServiceDescription(ServiceDesc serviceDescription) {
        if (serviceDescription == null) {
            return;
        }
        this.serviceDescription = serviceDescription;
    }

    public void setPropertyParent(Hashtable parent) {
        if (this.options == null) {
            this.options = new LockableHashtable();
        }
        ((LockableHashtable)this.options).setParent(parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        if (this.serviceDescription == null || this.serviceDescription.getWSDLFile() == null) {
            super.generateWSDL(msgContext);
            return;
        }
        InputStream instream = null;
        try {
            try {
                String filename = this.serviceDescription.getWSDLFile();
                File file = new File(filename);
                if (file.exists()) {
                    instream = new FileInputStream(filename);
                } else {
                    instream = ClassUtils.getResourceAsStream(this.getClass(), filename);
                    if (instream == null) {
                        String errorText = Messages.getMessage("wsdlFileMissing", filename);
                        throw new AxisFault(errorText);
                    }
                }
                Document doc = XMLUtils.newDocument(instream);
                msgContext.setProperty("WSDL", doc);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            Object var7_8 = null;
            if (instream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (instream == null) throw throwable;
            try {
                instream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        instream.close();
        return;
    }

    public void start() {
    }

    public void stop() {
    }

    public void enableTransport(String transportName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enableTransport00", "" + this, transportName));
        }
        if (this.validTransports == null) {
            this.validTransports = new Vector();
        }
        this.validTransports.addElement(transportName);
    }

    public void disableTransport(String transportName) {
        if (this.validTransports != null) {
            this.validTransports.removeElement(transportName);
        }
    }

    public boolean needsHighFidelityRecording() {
        return this.highFidelityRecording;
    }

    public void setHighFidelityRecording(boolean highFidelityRecording) {
        this.highFidelityRecording = highFidelityRecording;
    }

    public int getSendType() {
        return this.sendType;
    }

    public void setSendType(int sendType) {
        this.sendType = sendType;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        HandlerInfoChainFactory handlerFactory = (HandlerInfoChainFactory)this.getOption("handlerInfoChain");
        HandlerChainImpl handlerImpl = null;
        if (handlerFactory != null) {
            handlerImpl = (HandlerChainImpl)handlerFactory.createHandlerChain();
        }
        boolean result = true;
        try {
            if (handlerImpl != null) {
                result = handlerImpl.handleRequest((javax.xml.rpc.handler.MessageContext)msgContext);
            }
            if (result) {
                try {
                    super.invoke(msgContext);
                }
                catch (AxisFault e) {
                    msgContext.setPastPivot(true);
                    if (handlerImpl != null) {
                        handlerImpl.handleFault((javax.xml.rpc.handler.MessageContext)msgContext);
                        handlerImpl.destroy();
                    }
                    throw e;
                }
            } else {
                msgContext.setPastPivot(true);
            }
            if (handlerImpl != null) {
                handlerImpl.handleResponse((javax.xml.rpc.handler.MessageContext)msgContext);
                handlerImpl.destroy();
            }
        }
        catch (SOAPFaultException e) {
            msgContext.setPastPivot(true);
            throw AxisFault.makeFault((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            SOAPFault fault = new SOAPFault(new AxisFault("Server", "Server Error", null, null));
            SOAPEnvelope env = new SOAPEnvelope();
            env.addBodyElement(fault);
            Message message = new Message(env);
            message.setMessageType("response");
            msgContext.setResponseMessage(message);
            throw AxisFault.makeFault(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MustUnderstandChecker
    extends BasicHandler {
        public void invoke(MessageContext msgContext) throws AxisFault {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("semanticCheck00"));
            }
            ArrayList acts = SOAPService.this.getActors();
            SOAPEnvelope env = msgContext.getRequestMessage().getSOAPEnvelope();
            Vector headers = env.getHeadersByActor(acts);
            Vector<SOAPHeaderElement> misunderstoodHeaders = null;
            Enumeration enumeration = headers.elements();
            while (enumeration.hasMoreElements()) {
                SOAPHeaderElement header = (SOAPHeaderElement)enumeration.nextElement();
                if (!header.getMustUnderstand() || header.isProcessed()) continue;
                if (misunderstoodHeaders == null) {
                    misunderstoodHeaders = new Vector<SOAPHeaderElement>();
                }
                misunderstoodHeaders.addElement(header);
            }
            SOAPConstants soapConstants = msgContext.getSOAPConstants();
            if (misunderstoodHeaders != null) {
                AxisFault fault = new AxisFault(soapConstants.getMustunderstandFaultQName(), null, null, null, null, null);
                StringBuffer whatWasMissUnderstood = new StringBuffer(256);
                if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    enumeration = misunderstoodHeaders.elements();
                    while (enumeration.hasMoreElements()) {
                        SOAPHeaderElement badHeader = (SOAPHeaderElement)enumeration.nextElement();
                        QName badQName = new QName(badHeader.getNamespaceURI(), badHeader.getName());
                        if (whatWasMissUnderstood.length() != 0) {
                            whatWasMissUnderstood.append(", ");
                        }
                        whatWasMissUnderstood.append(badQName.toString());
                        SOAPHeaderElement newHeader = new SOAPHeaderElement("http://www.w3.org/2003/05/soap-envelope", "NotUnderstood");
                        newHeader.addAttribute(null, "qname", badQName);
                        fault.addHeader(newHeader);
                    }
                }
                fault.setFaultString(Messages.getMessage("noUnderstand00", whatWasMissUnderstood.toString()));
                throw fault;
            }
        }
    }
}

