/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AbstractQueryStringHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;

public class QSWSDLHandler
extends AbstractQueryStringHandler {
    public void invoke(MessageContext msgContext) throws AxisFault {
        this.configureFromContext(msgContext);
        AxisServer engine = (AxisServer)msgContext.getProperty("transport.http.plugin.engine");
        PrintWriter writer = (PrintWriter)msgContext.getProperty("transport.http.plugin.writer");
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        try {
            engine.generateWSDL(msgContext);
            Document doc = (Document)msgContext.getProperty("WSDL");
            if (doc != null) {
                response.setContentType("text/xml");
                XMLUtils.PrettyDocumentToWriter(doc, writer);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(response, writer, "noWSDL02", null);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.processAxisFault(axisFault);
                response.setStatus(404);
                this.reportNoWSDL(response, writer, "noWSDL01", axisFault);
            }
            throw axisFault;
        }
    }

    private void reportNoWSDL(HttpServletResponse res, PrintWriter writer, String moreDetailCode, AxisFault axisFault) {
        res.setStatus(404);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
        if (moreDetailCode != null) {
            writer.println("<p>" + Messages.getMessage(moreDetailCode) + "</p>");
        }
        if (axisFault != null && this.isDevelopment()) {
            this.writeFault(writer, axisFault);
        }
    }
}

