/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    static final QName VALUE_QNAME = Utils.findQName("", "value");
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS", "anySimpleType"};
    private static final Set schemaTypeSet = new HashSet<String>(Arrays.asList(schemaTypes));

    public static boolean isMixed(Node node) {
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            String mixed = ((Element)node).getAttribute("mixed");
            if (mixed != null && mixed.length() > 0) {
                return "true".equalsIgnoreCase(mixed) || "1".equals(mixed);
            }
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent")) continue;
                mixed = ((Element)kid).getAttribute("mixed");
                return "true".equalsIgnoreCase(mixed) || "1".equals(mixed);
            }
        }
        return false;
    }

    public static boolean isWrappedType(Node node) {
        NodeList children;
        if (node == null) {
            return false;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            boolean hasComplexType = false;
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                hasComplexType = true;
                break;
            }
            if (!hasComplexType) {
                return false;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            int j;
            children = node.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexContent")) {
                    return false;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                return false;
            }
            children = node.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                QName subNodeKind = Utils.getNodeQName(children.item(j));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    Node sequenceNode = children.item(j);
                    NodeList sequenceChildren = sequenceNode.getChildNodes();
                    for (int k = 0; k < sequenceChildren.getLength(); ++k) {
                        QName sequenceSubNodeKind = Utils.getNodeQName(sequenceChildren.item(k));
                        if (sequenceSubNodeKind == null || !Constants.isSchemaXSD(sequenceSubNodeKind.getNamespaceURI()) || sequenceSubNodeKind.getLocalPart().equals("element")) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static Vector getContainedElementDeclarations(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            int j;
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            for (j = 0; j < children.getLength(); ++j) {
                kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexContent")) {
                    complexContent = kid;
                    break;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                simpleContent = kid;
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension") && !SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    extension = kid;
                }
            }
            if (simpleContent != null) {
                children = simpleContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    QName extensionOrRestrictionKind = Utils.getNodeQName(children.item(j));
                    if (extensionOrRestrictionKind == null || !extensionOrRestrictionKind.getLocalPart().equals("extension") && !extensionOrRestrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(extensionOrRestrictionKind.getNamespaceURI())) continue;
                    QName extendsOrRestrictsType = Utils.getTypeQName(children.item(j), new BooleanHolder(), false);
                    Vector<ElementDecl> v = new Vector<ElementDecl>();
                    ElementDecl elem = new ElementDecl();
                    elem.setType(symbolTable.getTypeEntry(extendsOrRestrictsType, false));
                    elem.setName(VALUE_QNAME);
                    v.add(elem);
                    return v;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            Vector v = new Vector();
            for (int j2 = 0; j2 < children.getLength(); ++j2) {
                QName subNodeKind = Utils.getNodeQName(children.item(j2));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j2), symbolTable));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j2), symbolTable));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j2), symbolTable));
                    continue;
                }
                if (!subNodeKind.getLocalPart().equals("group")) continue;
                v.addAll(SchemaUtils.processGroupNode(children.item(j2), symbolTable));
            }
            return v;
        }
        if (SchemaUtils.isXSDNode(node, "group")) {
            children = node.getChildNodes();
            Vector v = new Vector();
            for (int j = 0; j < children.getLength(); ++j) {
                QName subNodeKind = Utils.getNodeQName(children.item(j));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j), symbolTable));
                    continue;
                }
                if (!subNodeKind.getLocalPart().equals("choice")) continue;
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
            }
            return v;
        }
        QName[] simpleQName = SchemaUtils.getContainedSimpleTypes(node);
        if (simpleQName != null) {
            Vector<ElementDecl> v = null;
            for (int i = 0; i < simpleQName.length; ++i) {
                Type simpleType = symbolTable.getType(simpleQName[i]);
                if (simpleType == null) continue;
                if (v == null) {
                    v = new Vector<ElementDecl>();
                }
                ElementDecl elem = new ElementDecl();
                elem.setType(simpleType);
                if (simpleQName.length > 1) {
                    elem.setName(new QName("", simpleQName[i].getLocalPart() + "Value"));
                } else {
                    elem.setName(new QName("", "value"));
                }
                v.add(elem);
            }
            return v;
        }
        return null;
    }

    private static Vector processChoiceNode(Node choiceNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = choiceNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ElementDecl elem;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("group")) {
                v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("element") || (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) == null) continue;
            v.add(elem);
        }
        return v;
    }

    private static Node getChildByName(Node parentNode, String name) throws DOMException {
        if (parentNode == null) {
            return null;
        }
        NodeList children = parentNode.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || child.getNodeName() == null || !name.equals(child.getNodeName())) continue;
                return child;
            }
        }
        return null;
    }

    public static String getTextByPath(Node root, String path) throws DOMException {
        StringTokenizer st = new StringTokenizer(path, "/");
        Node node = root;
        while (st.hasMoreTokens()) {
            String elementName = st.nextToken();
            Node child = SchemaUtils.getChildByName(node, elementName);
            if (child == null) {
                throw new DOMException(8, "could not find " + elementName);
            }
            node = child;
        }
        String text = "";
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || child.getNodeName() == null || !child.getNodeName().equals("#text") && !child.getNodeName().equals("#cdata-section")) continue;
                text = text + child.getNodeValue();
            }
        }
        return text;
    }

    public static String getAnnotationDocumentation(Node typeNode) {
        NodeList children;
        Node documentationNode;
        Node annotationNode;
        for (annotationNode = typeNode.getFirstChild(); annotationNode != null && !SchemaUtils.isXSDNode(annotationNode, "annotation"); annotationNode = annotationNode.getNextSibling()) {
        }
        if (annotationNode != null) {
            for (documentationNode = annotationNode.getFirstChild(); documentationNode != null && !SchemaUtils.isXSDNode(documentationNode, "documentation"); documentationNode = documentationNode.getNextSibling()) {
            }
        } else {
            documentationNode = null;
        }
        String text = "";
        if (documentationNode != null && (children = documentationNode.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || child.getNodeName() == null || !child.getNodeName().equals("#text") && !child.getNodeName().equals("#cdata-section")) continue;
                text = text + child.getNodeValue();
            }
        }
        return text;
    }

    private static Vector processSequenceNode(Node sequenceNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = sequenceNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ElementDecl elem;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("group")) {
                v.addAll(SchemaUtils.processGroupNode(children.item(j), symbolTable));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("any")) {
                Type type = symbolTable.getType(Constants.XSD_ANY);
                ElementDecl elem2 = new ElementDecl(type, Utils.findQName("", "any"));
                elem2.setAnyElement(true);
                v.add(elem2);
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("element") || (elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable)) == null) continue;
            v.add(elem);
        }
        return v;
    }

    private static Vector processGroupNode(Node groupNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        if (groupNode.getAttributes().getNamedItem("ref") == null) {
            NodeList children = groupNode.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                QName subNodeKind = Utils.getNodeQName(children.item(j));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("choice")) {
                    v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable));
                    continue;
                }
                if (!subNodeKind.getLocalPart().equals("all")) continue;
                v.addAll(SchemaUtils.processAllNode(children.item(j), symbolTable));
            }
        } else {
            BooleanHolder forElement = new BooleanHolder();
            QName nodeName = Utils.getTypeQName(groupNode, forElement, false);
            TypeEntry type = symbolTable.getTypeEntry(nodeName, forElement.value);
            if (type != null) {
                v.add(new ElementDecl(type, nodeName));
            }
        }
        return v;
    }

    private static Vector processAllNode(Node allNode, SymbolTable symbolTable) {
        Vector<ElementDecl> v = new Vector<ElementDecl>();
        NodeList children = allNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ElementDecl elem;
            Node kid = children.item(j);
            if (!SchemaUtils.isXSDNode(kid, "element") || (elem = SchemaUtils.processChildElementNode(kid, symbolTable)) == null) continue;
            v.add(elem);
        }
        return v;
    }

    private static ElementDecl processChildElementNode(Node elementNode, SymbolTable symbolTable) {
        QName nodeName = Utils.getNodeNameQName(elementNode);
        BooleanHolder forElement = new BooleanHolder();
        String comments = null;
        comments = SchemaUtils.getAnnotationDocumentation(elementNode);
        QName nodeType = Utils.getTypeQName(elementNode, forElement, false);
        TypeEntry type = symbolTable.getTypeEntry(nodeType, forElement.value);
        if (!forElement.value) {
            String def;
            String form = Utils.getAttribute(elementNode, "form");
            if (form != null && form.equals("unqualified")) {
                nodeName = Utils.findQName("", nodeName.getLocalPart());
            } else if (form == null && ((def = Utils.getScopedAttribute(elementNode, "elementFormDefault")) == null || def.equals("unqualified"))) {
                nodeName = Utils.findQName("", nodeName.getLocalPart());
            }
        }
        if (type != null) {
            ElementDecl elem = new ElementDecl(type, nodeName);
            elem.setDocumentation(comments);
            String minOccurs = Utils.getAttribute(elementNode, "minOccurs");
            if (minOccurs != null && minOccurs.equals("0")) {
                elem.setMinOccursIs0(true);
            }
            elem.setNillable(JavaUtils.isTrueExplicitly(Utils.getAttribute(elementNode, "nillable")));
            return elem;
        }
        return null;
    }

    public static QName getElementAnonQName(Node node) {
        if (SchemaUtils.isXSDNode(node, "element")) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType") && !SchemaUtils.isXSDNode(kid, "simpleType")) continue;
                return Utils.getNodeNameQName(kid);
            }
        }
        return null;
    }

    public static QName getAttributeAnonQName(Node node) {
        if (SchemaUtils.isXSDNode(node, "attribute")) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType") && !SchemaUtils.isXSDNode(kid, "simpleType")) continue;
                return Utils.getNodeNameQName(kid);
            }
        }
        return null;
    }

    public static boolean isSimpleTypeOrSimpleContent(Node node) {
        NodeList children;
        if (node == null) {
            return false;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexType")) {
                    node = kid;
                    break;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleType")) continue;
                return true;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            return true;
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (SchemaUtils.isXSDNode(kid, "complexContent")) {
                    complexContent = kid;
                    break;
                }
                if (!SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                simpleContent = kid;
            }
            if (complexContent != null) {
                return false;
            }
            if (simpleContent != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isXSDNode(Node node, String schemaLocalName) {
        if (node != null && Constants.isSchemaXSD(node.getNamespaceURI())) {
            String localName = node.getLocalName();
            return localName != null && localName.equals(schemaLocalName);
        }
        return false;
    }

    public static TypeEntry getComplexElementRestrictionBase(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "complexType")) continue;
                node = complexNode = children.item(j);
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            int j;
            children = node.getChildNodes();
            Node content = null;
            Node restriction = null;
            for (j = 0; j < children.getLength() && content == null; ++j) {
                kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent")) continue;
                content = kid;
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength() && restriction == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    restriction = kid;
                }
            }
            if (restriction == null) {
                return null;
            }
            QName restrictionType = Utils.getTypeQName(restriction, new BooleanHolder(), false);
            if (restrictionType == null) {
                return null;
            }
            return symbolTable.getType(restrictionType);
        }
        return null;
    }

    public static TypeEntry getComplexElementExtensionBase(Node node, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        Object cached = (TypeEntry)symbolTable.node2ExtensionBase.get(node);
        if (cached != null) {
            return cached;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "complexType")) continue;
                node = complexNode = children.item(j);
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            QName extendsType;
            Node kid;
            int j;
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && content == null; ++j) {
                kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                content = kid;
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension")) continue;
                    extension = kid;
                }
            }
            cached = extension == null ? null : ((extendsType = Utils.getTypeQName(extension, new BooleanHolder(), false)) == null ? null : symbolTable.getType(extendsType));
        }
        symbolTable.node2ExtensionBase.put(node, cached);
        return cached;
    }

    public static QName getSimpleTypeBase(Node node) {
        QName[] qname = SchemaUtils.getContainedSimpleTypes(node);
        if (qname != null && qname.length > 0) {
            return qname[0];
        }
        return null;
    }

    public static QName[] getContainedSimpleTypes(Node node) {
        NodeList children;
        QName[] baseQNames = null;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "simpleType")) continue;
                node = children.item(j);
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            children = node.getChildNodes();
            Node restrictionNode = null;
            Node unionNode = null;
            for (int j = 0; j < children.getLength() && restrictionNode == null; ++j) {
                if (SchemaUtils.isXSDNode(children.item(j), "restriction")) {
                    restrictionNode = children.item(j);
                    continue;
                }
                if (!SchemaUtils.isXSDNode(children.item(j), "union")) continue;
                unionNode = children.item(j);
            }
            if (restrictionNode != null) {
                baseQNames = new QName[]{Utils.getTypeQName(restrictionNode, new BooleanHolder(), false)};
            }
            if (unionNode != null) {
                baseQNames = Utils.getMemberTypeQNames(unionNode);
            }
            if (baseQNames != null && restrictionNode != null && unionNode != null) {
                NodeList enums = restrictionNode.getChildNodes();
                for (int i = 0; i < enums.getLength(); ++i) {
                    if (!SchemaUtils.isXSDNode(enums.item(i), "enumeration")) continue;
                    return null;
                }
            }
        }
        return baseQNames;
    }

    public static Node getRestrictionOrExtensionNode(Node node) {
        NodeList children;
        Node re = null;
        if (node == null) {
            return re;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node n = children.item(j);
                if (!SchemaUtils.isXSDNode(n, "simpleType") && !SchemaUtils.isXSDNode(n, "complexType") && !SchemaUtils.isXSDNode(n, "simpleContent")) continue;
                node = n;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType") || SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            children = node.getChildNodes();
            Node complexContent = null;
            if (node.getLocalName().equals("complexType")) {
                for (int j = 0; j < children.getLength() && complexContent == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                    complexContent = kid;
                }
                node = complexContent;
            }
            if (node != null) {
                children = node.getChildNodes();
                for (int j = 0; j < children.getLength() && re == null; ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension") && !SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    re = kid;
                }
            }
        }
        return re;
    }

    public static QName getArrayComponentQName(Node node, IntHolder dims, SymbolTable symbolTable) {
        dims.value = 1;
        QName qName = SchemaUtils.getCollectionComponentQName(node);
        if (qName == null) {
            qName = SchemaUtils.getArrayComponentQName_JAXRPC(node, dims, symbolTable);
        }
        return qName;
    }

    public static QName getCollectionComponentQName(Node node) {
        QName fullQName;
        BooleanHolder forElement;
        QName componentQName;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element") && (componentQName = Utils.getTypeQName(node, forElement = new BooleanHolder(), true)) != null && !componentQName.equals(fullQName = Utils.getTypeQName(node, forElement, false))) {
            return componentQName;
        }
        return null;
    }

    private static QName getArrayComponentQName_JAXRPC(Node node, IntHolder dims, SymbolTable symbolTable) {
        NodeList children;
        dims.value = 0;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            children = node.getChildNodes();
            Node complexContentNode = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                complexContentNode = kid;
                break;
            }
            Node restrictionNode = null;
            if (complexContentNode != null) {
                children = complexContentNode.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    restrictionNode = kid;
                    break;
                }
            }
            QName baseType = null;
            if (!(restrictionNode == null || (baseType = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false)) == null || baseType.getLocalPart().equals("Array") && Constants.isSOAP_ENC(baseType.getNamespaceURI()) || symbolTable.arrayTypeQNames.contains(baseType))) {
                baseType = null;
            }
            Node groupNode = null;
            Node attributeNode = null;
            if (baseType != null) {
                children = restrictionNode.getChildNodes();
                for (int j = 0; j < children.getLength() && groupNode == null && attributeNode == null; ++j) {
                    BooleanHolder isRef;
                    QName refQName;
                    Node kid = children.item(j);
                    if ((SchemaUtils.isXSDNode(kid, "sequence") || SchemaUtils.isXSDNode(kid, "all")) && (groupNode = kid).getChildNodes().getLength() == 0) {
                        groupNode = null;
                    }
                    if (!SchemaUtils.isXSDNode(kid, "attribute") || (refQName = Utils.getTypeQName(kid, isRef = new BooleanHolder(), false)) == null || !isRef.value || !refQName.getLocalPart().equals("arrayType") || !Constants.isSOAP_ENC(refQName.getNamespaceURI())) continue;
                    attributeNode = kid;
                }
            }
            if (attributeNode != null) {
                int i;
                String wsdlArrayTypeValue = null;
                Vector attrs = Utils.getAttributesWithLocalName(attributeNode, "arrayType");
                for (i = 0; i < attrs.size() && wsdlArrayTypeValue == null; ++i) {
                    Node attrNode = (Node)attrs.elementAt(i);
                    String attrName = attrNode.getNodeName();
                    QName attrQName = Utils.getQNameFromPrefixedName(attributeNode, attrName);
                    if (!Constants.isWSDL(attrQName.getNamespaceURI())) continue;
                    wsdlArrayTypeValue = attrNode.getNodeValue();
                }
                if (wsdlArrayTypeValue != null && (i = wsdlArrayTypeValue.indexOf(91)) > 0) {
                    String prefixedName = wsdlArrayTypeValue.substring(0, i);
                    String mangledString = wsdlArrayTypeValue.replace(',', '[');
                    dims.value = 0;
                    int index = mangledString.indexOf(91);
                    while (index > 0) {
                        ++dims.value;
                        index = mangledString.indexOf(91, index + 1);
                    }
                    return Utils.getQNameFromPrefixedName(restrictionNode, prefixedName);
                }
            } else if (groupNode != null) {
                String maxOccursValue;
                NodeList elements = groupNode.getChildNodes();
                Node elementNode = null;
                for (int i = 0; i < elements.getLength() && elementNode == null; ++i) {
                    Node kid = elements.item(i);
                    if (!SchemaUtils.isXSDNode(kid, "element")) continue;
                    elementNode = elements.item(i);
                    break;
                }
                if (elementNode != null && (maxOccursValue = Utils.getAttribute(elementNode, "maxOccurs")) != null && maxOccursValue.equalsIgnoreCase("unbounded")) {
                    dims.value = 1;
                    return Utils.getTypeQName(elementNode, new BooleanHolder(), true);
                }
            }
        }
        return null;
    }

    private static void addAttributeToVector(Vector v, Node child, SymbolTable symbolTable) {
        QName attributeName = Utils.getNodeNameQName(child);
        BooleanHolder forElement = new BooleanHolder();
        QName attributeType = Utils.getTypeQName(child, forElement, false);
        if (!forElement.value) {
            String def;
            String form = Utils.getAttribute(child, "form");
            if (form != null && form.equals("unqualified")) {
                attributeName = Utils.findQName("", attributeName.getLocalPart());
            } else if (form == null && ((def = Utils.getScopedAttribute(child, "attributeFormDefault")) == null || def.equals("unqualified"))) {
                attributeName = Utils.findQName("", attributeName.getLocalPart());
            }
        } else {
            attributeName = attributeType;
        }
        TypeEntry type = symbolTable.getTypeEntry(attributeType, forElement.value);
        if (type != null && attributeName != null) {
            v.add(type);
            v.add(attributeName);
        }
    }

    private static void addAttributeToVector(Vector v, SymbolTable symbolTable, QName type, QName name) {
        TypeEntry typeEnt = symbolTable.getTypeEntry(type, false);
        if (typeEnt != null) {
            v.add(typeEnt);
            v.add(name);
        }
    }

    private static void addAttributeGroupToVector(Vector v, Node attrGrpnode, SymbolTable symbolTable) {
        QName attributeGroupType = Utils.getTypeQName(attrGrpnode, new BooleanHolder(), false);
        TypeEntry type = symbolTable.getTypeEntry(attributeGroupType, false);
        if (type != null) {
            if (type.getNode() != null) {
                NodeList children = type.getNode().getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node kid = children.item(j);
                    if (SchemaUtils.isXSDNode(kid, "attribute")) {
                        SchemaUtils.addAttributeToVector(v, kid, symbolTable);
                        continue;
                    }
                    if (!SchemaUtils.isXSDNode(kid, "attributeGroup")) continue;
                    SchemaUtils.addAttributeGroupToVector(v, kid, symbolTable);
                }
            } else if (type.isBaseType()) {
                if (type.getQName().equals(Constants.SOAP_COMMON_ATTRS11)) {
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_ID, new QName("http://schemas.xmlsoap.org/soap/encoding/", "id"));
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_ANYURI, new QName("http://schemas.xmlsoap.org/soap/encoding/", "href"));
                } else if (type.getQName().equals(Constants.SOAP_COMMON_ATTRS12)) {
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_ID, new QName("http://www.w3.org/2003/05/soap-encoding", "id"));
                } else if (type.getQName().equals(Constants.SOAP_ARRAY_ATTRS11)) {
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_STRING, new QName("http://www.w3.org/2003/05/soap-encoding", "arrayType"));
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_STRING, new QName("http://www.w3.org/2003/05/soap-encoding", "offset"));
                } else if (type.getQName().equals(Constants.SOAP_ARRAY_ATTRS12)) {
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_STRING, new QName("http://www.w3.org/2003/05/soap-encoding", "arraySize"));
                    SchemaUtils.addAttributeToVector(v, symbolTable, Constants.XSD_QNAME, new QName("http://www.w3.org/2003/05/soap-encoding", "itemType"));
                }
            }
        }
    }

    public static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable) {
        NodeList children;
        Vector v = null;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexType")) continue;
                node = kid;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node kid;
            int j;
            children = node.getChildNodes();
            Node content = null;
            for (j = 0; j < children.getLength(); ++j) {
                kid = children.item(j);
                if (!SchemaUtils.isXSDNode(kid, "complexContent") && !SchemaUtils.isXSDNode(kid, "simpleContent")) continue;
                content = kid;
                break;
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    kid = children.item(j);
                    if (!SchemaUtils.isXSDNode(kid, "extension") && !SchemaUtils.isXSDNode(kid, "restriction")) continue;
                    node = kid;
                    break;
                }
            }
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!SchemaUtils.isXSDNode(child, "attribute") && !SchemaUtils.isXSDNode(child, "attributeGroup")) continue;
                if (v == null) {
                    v = new Vector();
                }
                if (SchemaUtils.isXSDNode(child, "attributeGroup")) {
                    SchemaUtils.addAttributeGroupToVector(v, child, symbolTable);
                    continue;
                }
                SchemaUtils.addAttributeToVector(v, child, symbolTable);
            }
        }
        return v;
    }

    private static boolean isSimpleSchemaType(String s) {
        if (s == null) {
            return false;
        }
        return schemaTypeSet.contains(s);
    }

    public static boolean isSimpleSchemaType(QName qname) {
        if (qname == null || !Constants.isSchemaXSD(qname.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isSimpleSchemaType(qname.getLocalPart());
    }

    public static TypeEntry getBaseType(TypeEntry type, SymbolTable symbolTable) {
        QName baseQName;
        Node node = type.getNode();
        TypeEntry base = SchemaUtils.getComplexElementExtensionBase(node, symbolTable);
        if (base == null) {
            base = SchemaUtils.getComplexElementRestrictionBase(node, symbolTable);
        }
        if (base == null && (baseQName = SchemaUtils.getSimpleTypeBase(node)) != null) {
            base = symbolTable.getType(baseQName);
        }
        return base;
    }

    public static boolean isListWithItemType(Node node) {
        return SchemaUtils.getListItemType(node) != null;
    }

    public static QName getListItemType(Node node) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            children = node.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "simpleType")) continue;
                node = children.item(j);
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            children = node.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                if (!SchemaUtils.isXSDNode(children.item(j), "list")) continue;
                Node listNode = children.item(j);
                Element listElement = (Element)listNode;
                String type = listElement.getAttribute("itemType");
                if (type.equals("")) {
                    return null;
                }
                int colonIndex = type.lastIndexOf(":");
                if (colonIndex > 0) {
                    type = type.substring(colonIndex + 1);
                }
                return new QName("http://www.w3.org/2001/XMLSchema", type + "[]");
            }
        }
        return null;
    }
}

