/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class LongConversionUtil {
    private LongConversionUtil() {
    }

    public static Long toLong(Object o) {
        return LongConversionUtil.toLong(o, null);
    }

    public static Long toLong(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return new Long(((Number)o).longValue());
        }
        if (o instanceof String) {
            return new Long((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Long(new SimpleDateFormat(pattern).format(o));
            }
            return new Long(((Date)o).getTime());
        }
        return new Long(o.toString());
    }

    public static long toPrimitiveLong(Object o) {
        return LongConversionUtil.toPrimitiveLong(o, null);
    }

    public static long toPrimitiveLong(Object o, String pattern) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Long.parseLong(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return Long.parseLong(o.toString());
    }
}

