/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openamf.AMFBody;
import org.openamf.AMFHeader;

public class AMFMessage
implements Serializable {
    private static final int CURRENT_VERSION = 0;
    protected int version = 0;
    protected List headers = new ArrayList();
    protected List bodies = new ArrayList();

    public void addHeader(String key, boolean required, Object value) {
        this.addHeader(new AMFHeader(key, required, value));
    }

    public void addHeader(AMFHeader header) {
        this.headers.add(header);
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public AMFHeader getHeader(int index) {
        return (AMFHeader)this.headers.get(index);
    }

    public List getHeaders() {
        return this.headers;
    }

    public void addBody(String target, String response, Object value, byte type) {
        this.addBody(new AMFBody(target, response, value, type));
    }

    public void addBody(AMFBody body) {
        this.bodies.add(body);
    }

    public int getBodyCount() {
        return this.bodies.size();
    }

    public AMFBody getBody(int index) {
        return (AMFBody)this.bodies.get(index);
    }

    public Iterator getBodies() {
        return this.bodies.iterator();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getBodiesString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.bodies.size(); ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            AMFBody amfBody = (AMFBody)this.bodies.get(i);
            sb.append(amfBody);
        }
        return sb.toString();
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("[AMFMessage: {version=");
        sb.append(this.version);
        sb.append(", headers={");
        for (i = 0; i < this.headers.size(); ++i) {
            AMFHeader amfHeader = (AMFHeader)this.headers.get(i);
            sb.append(amfHeader);
        }
        sb.append("}, bodies={");
        for (i = 0; i < this.bodies.size(); ++i) {
            AMFBody amfBody = (AMFBody)this.bodies.get(i);
            sb.append(amfBody);
        }
        sb.append("}}]");
        return sb.toString();
    }
}

