/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openamf.AMFMessage;

public class RequestContext {
    private static ThreadLocal httpRequestLocal = new ThreadLocal();
    private static ThreadLocal requestMsgLocal = new ThreadLocal();

    private RequestContext() {
    }

    public static void setHttpServletRequest(HttpServletRequest req) {
        httpRequestLocal.set(req);
    }

    public static void clear() {
        httpRequestLocal.set(null);
        requestMsgLocal.set(null);
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest req = (HttpServletRequest)httpRequestLocal.get();
        return req;
    }

    public static HttpSession getHttpSession() {
        HttpServletRequest req = RequestContext.getHttpServletRequest();
        if (req == null) {
            throw new IllegalStateException("HttpServletRequest is null");
        }
        return req.getSession(true);
    }

    public static AMFMessage getRequestMessage() {
        return (AMFMessage)requestMsgLocal.get();
    }

    public static void setRequestMessage(AMFMessage m) {
        requestMsgLocal.set(m);
    }
}

