/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.BatchHandler;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicBatchHandler
extends BasicHandler
implements BatchHandler {
    private static Logger logger_;
    private int batchSize_ = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.extension.jdbc.impl.BasicBatchHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public BasicBatchHandler() {
    }

    public BasicBatchHandler(DataSource dataSource, String sql, int batchSize) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setBatchSize(batchSize);
    }

    public int getBatchSize() {
        return this.batchSize_;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize_ = batchSize;
    }

    public int execute(List list) throws SQLRuntimeException {
        int n;
        Connection connection = this.getConnection();
        try {
            n = this.execute(connection, list);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ConnectionUtil.close((Connection)connection);
            throw throwable;
        }
        ConnectionUtil.close((Connection)connection);
        return n;
    }

    protected int execute(Connection connection, List list) {
        int n;
        PreparedStatement ps = this.prepareStatement(connection);
        int batchSize = this.batchSize_ > 0 ? this.batchSize_ : list.size();
        try {
            int i = 0;
            int j = 0;
            while (i < list.size()) {
                Object[] args = (Object[])list.get(i);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)this.getCompleteSql(args));
                }
                this.bindArgs(ps, args);
                PreparedStatementUtil.addBatch((PreparedStatement)ps);
                if (j == batchSize - 1 || i == list.size() - 1) {
                    PreparedStatementUtil.executeBatch((PreparedStatement)ps);
                    j = 0;
                } else {
                    ++j;
                }
                ++i;
            }
            n = list.size();
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            StatementUtil.close((Statement)ps);
            throw throwable;
        }
        StatementUtil.close((Statement)ps);
        return n;
    }
}

