/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

public class TraceInterceptor
extends AbstractInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.getTargetClass(invocation).getName());
        buf.append("#");
        buf.append(invocation.getMethod().getName());
        buf.append("(");
        Object[] args = invocation.getArguments();
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                buf.append(args[i]);
                buf.append(", ");
                ++i;
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        Object ret = null;
        Throwable cause = null;
        System.out.println("BEGIN " + buf);
        try {
            ret = invocation.proceed();
            buf.append(" : ");
            buf.append(ret);
        }
        catch (Throwable t) {
            buf.append(" Throwable:");
            buf.append(t);
            cause = t;
        }
        System.out.println("END " + buf);
        if (cause == null) {
            return ret;
        }
        cause.printStackTrace();
        throw cause;
    }
}

