/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.MethodInvocationImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;

public final class AopProxy
implements MethodInterceptor {
    private static Logger logger_;
    private static final int AOP_PROXY_INDEX = 0;
    private static final int EQUALS_INTERCEPTOR_INDEX = 1;
    private static final int NONE_INTERCEPTOR_INDEX = 2;
    private Class targetClass_;
    private Pointcut defaultPointcut_;
    private Map interceptorsMap_ = new HashMap();
    private Map parameters_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.framework.aop.proxy.AopProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger(clazz);
    }

    public AopProxy(Class targetClass, Aspect[] aspects) {
        this(targetClass, aspects, null);
    }

    public AopProxy(Class targetClass, Aspect[] aspects, Map parameters) {
        this.setTargetClass(targetClass);
        this.setAspects(aspects);
        this.parameters_ = parameters;
    }

    private void setTargetClass(Class targetClass) {
        this.targetClass_ = targetClass;
        this.defaultPointcut_ = new PointcutImpl(targetClass);
    }

    private void setAspects(Aspect[] aspects) {
        if (aspects == null || aspects.length == 0) {
            throw new EmptyRuntimeException("aspects");
        }
        int i = 0;
        while (i < aspects.length) {
            Aspect aspect = aspects[i];
            if (aspect.getPointcut() == null) {
                aspect.setPointcut(this.defaultPointcut_);
            }
            ++i;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.targetClass_);
        String[] names = beanDesc.getMethodNames();
        int i2 = 0;
        while (i2 < names.length) {
            block8: {
                String name = names[i2];
                boolean applicableAspect = this.isApplicableAspect(beanDesc.getMethods(name));
                ArrayList<org.aopalliance.intercept.MethodInterceptor> interceptorList = new ArrayList<org.aopalliance.intercept.MethodInterceptor>();
                int j = 0;
                while (j < aspects.length) {
                    Aspect aspect = aspects[j];
                    if (aspect.getPointcut().isApplied(name)) {
                        if (!applicableAspect) {
                            logger_.log("WSSR0009", new Object[]{this.targetClass_.getName(), name});
                            break block8;
                        }
                        interceptorList.add(aspect.getMethodInterceptor());
                    }
                    ++j;
                }
                if (interceptorList.size() > 0) {
                    this.interceptorsMap_.put(name, interceptorList.toArray(new org.aopalliance.intercept.MethodInterceptor[interceptorList.size()]));
                }
            }
            ++i2;
        }
    }

    public Object create() {
        Enhancer e = this.setupEnhancer();
        return e.create();
    }

    public Object create(Class[] argTypes, Object[] args) {
        Enhancer e = this.setupEnhancer();
        return e.create(argTypes, args);
    }

    private Enhancer setupEnhancer() {
        Enhancer e = new Enhancer();
        e.setSuperclass(this.targetClass_);
        e.setCallbacks(new Callback[]{this, new EqualsInterceptor(), NoOp.INSTANCE});
        e.setCallbackFilter((CallbackFilter)new MyCallbackFilter());
        return e;
    }

    private boolean isApplicableAspect(Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            int mod = methods[i].getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        org.aopalliance.intercept.MethodInterceptor[] interceptors = (org.aopalliance.intercept.MethodInterceptor[])this.interceptorsMap_.get(method.getName());
        MethodInvocationImpl invocation = new MethodInvocationImpl(obj, method, args, proxy, interceptors, this.targetClass_, this.parameters_);
        return invocation.proceed();
    }

    private class EqualsInterceptor
    implements MethodInterceptor {
        EqualsInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (args[0] == obj) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private class MyCallbackFilter
    implements CallbackFilter {
        static /* synthetic */ Class class$0;

        MyCallbackFilter() {
        }

        public int accept(Method method) {
            if (AopProxy.this.interceptorsMap_.containsKey(method.getName())) {
                return 0;
            }
            if (this.isEqualsMethod(method)) {
                return 1;
            }
            return 2;
        }

        private boolean isEqualsMethod(Method method) {
            return "equals".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getReturnType() == Boolean.TYPE;
        }
    }
}

