import org.seasar.flex.message.*;

function initApp() {
	messageLogic.getMessageManager("FLXMessages", "ja");
}


function processMessageManager(messageManager:MessageManager) {
	MessageManager.instance = messageManager;
}

function validate() {
    if (!mx.validators.Validator.isStructureValid(this, 'myModel')) {
        mx.controls.Alert.show(MessageManager.instance.getMessage("EFLX0002"), "Problem");
    }
}

function testMessage() {
	var messagePieces:Array = new Array();
	var varPiece:VariablePiece = new VariablePiece();
	varPiece.index = 0;
	var strPiece:StringPiece = new StringPiece();
	strPiece.value = "܂";
	messagePieces.push(varPiece);
	messagePieces.push(strPiece);
	var message:Message = new Message();
	message.messagePieces = messagePieces;
	var messages = new Object();
	messages["ESSR0001"] = message;
	var messageManager:MessageManager = new MessageManager();
	messageManager.messages = messages;
	MessageManager.instance = messageManager;
	var args:Array = new Array();
	args.push("hoge");
	mx.controls.Alert.show(MessageManager.instance.getMessage("ESSR0001", args));
}