/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.PointerCachedDataRow;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TextCache;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;

class TextTable
extends Table {
    private String dataSource = "";
    private String firstLine = "";
    private boolean isReversed = false;

    TextTable(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        super(database, hsqlName, n, n2);
    }

    private void openCache(String string, boolean bl, boolean bl2) throws HsqlException {
        if (string == null) {
            string = "";
        }
        this.database.logger.closeTextCache(this);
        this.cache = null;
        this.clearAllRows();
        if (string.length() > 0) {
            try {
                this.cache = this.database.logger.openTextCache(this, string, bl2, bl);
                ((TextCache)this.cache).setSourceIndexing(true);
                PointerCachedDataRow pointerCachedDataRow = (PointerCachedDataRow)this.getRow(0, null);
                while (pointerCachedDataRow != null) {
                    this.insertNoChange(pointerCachedDataRow);
                    pointerCachedDataRow = (PointerCachedDataRow)this.getRow(pointerCachedDataRow.nextPos, null);
                }
                ((TextCache)this.cache).setSourceIndexing(false);
            }
            catch (HsqlException hsqlException) {
                int n;
                int n2 = n = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
                if (!this.dataSource.equals(string) || bl != this.isReversed || bl2 != this.isReadOnly) {
                    this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
                } else {
                    if (this.cache != null) {
                        this.cache.closeFile();
                    }
                    this.cache = null;
                    this.dataSource = "";
                    this.isReversed = false;
                }
                throw Trace.error(76, new Object[]{new Integer(n), hsqlException.getMessage()});
            }
        }
        this.dataSource = string;
        this.isReversed = bl && string.length() > 0;
    }

    boolean equals(Session session, String string) {
        boolean bl = super.equals(session, string);
        if (bl && this.isReversed) {
            try {
                this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
            }
            catch (HsqlException hsqlException) {
                return false;
            }
        }
        return bl;
    }

    boolean equals(String string) {
        boolean bl = super.equals(string);
        if (bl && this.isReversed) {
            try {
                this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
            }
            catch (HsqlException hsqlException) {
                return false;
            }
        }
        return bl;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        if (this.isTemp) {
            Trace.check(session.getId() == this.ownerSessionId, 33);
        } else {
            session.checkAdmin();
        }
        try {
            string = string.trim();
            if (bl2 && FileUtil.exists(string)) {
                throw Trace.error(196, string);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException.getMessage());
        }
        if (bl || bl != this.isReversed || !this.dataSource.equals(string)) {
            this.openCache(string, bl, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    protected String getDataSource() {
        return this.dataSource;
    }

    protected boolean isDescDataSource() {
        return this.isReversed;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.dataSource.length() == 0) {
            throw Trace.error(48);
        }
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (this.isReversed && bl) {
            throw Trace.error(32);
        }
        this.openCache(this.dataSource, this.isReversed, bl);
        this.isReadOnly = bl;
    }

    boolean isIndexCached() {
        return false;
    }

    protected Table duplicate() throws HsqlException {
        return new TextTable(this.database, this.tableName, this.tableType, this.ownerSessionId);
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        CachedDataRow cachedDataRow = (CachedDataRow)this.cache.getRow(n, this);
        if (cachedDataRow == null) {
            return null;
        }
        if (node == null) {
            cachedDataRow.setNewNodes();
        } else {
            cachedDataRow.setPrimaryNode(node);
        }
        return cachedDataRow;
    }

    void drop() throws HsqlException {
        this.openCache("", false, false);
    }

    void setIndexRoots(String string) throws HsqlException {
    }
}

