/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.encoding;

import javax.xml.namespace.QName;

import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.wsdl.toJava.Utils;
import org.seasar.framework.util.ClassUtil;

/**
 * Java^XML^̃}bsO`̏ꍇɎo^^Cv}bsO̎łB <br>
 * Java^XML^ւ̃^Cv}bsO̎o^̓X[p[NX̋@\(ftHgł͖ɂĂ܂)̂܂܎g܂B
 * 
 * @author koichik
 */
public class AutoRegisterTypeMappingImpl extends TypeMappingImpl {
    /**
     * o^LɂăCX^X\z܂B
     * 
     * @param delegate
     *            Ϗ̃^Cv}bsO
     */
    public AutoRegisterTypeMappingImpl(final TypeMapping delegate) {
        super(delegate);
        setDoAutoTypes(true);
    }

    /**
     * XML^ɑΉJava^Ԃ܂B <br>
     * wXML^}bsOɓo^ĂȂ΁AXML^ϊJava^̖OŃX[p[NX猟邱ƂɂA^Cv}bsOo^܂B
     * 
     * @param xmlType
     *            XML^
     * @return Java^
     */
    public Class getClassForQName(final QName xmlType) {
        if (xmlType == null) {
            return null;
        }

        Class javaType = super.getClassForQName(xmlType);
        if (javaType != null) {
            return javaType;
        }

        final String packageName = Utils.makePackageName(xmlType.getNamespaceURI());
        final String className = xmlType.getLocalPart();
        try {
            javaType = ClassUtil.forName(packageName + "." + className);
        }
        catch (final Exception ignore) {
            return null;
        }

        getTypeQName(javaType);
        return javaType;
    }
}