/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.IgnoreCookiesSpec;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CookiePolicy {
    private static Map SPECS = Collections.synchronizedMap(new HashMap());
    public static final String BROWSER_COMPATIBILITY = "compatibility";
    public static final String NETSCAPE = "netscape";
    public static final String RFC_2109 = "rfc2109";
    public static final String IGNORE_COOKIES = "ignoreCookies";
    public static final String DEFAULT = "default";
    public static final int COMPATIBILITY = 0;
    public static final int NETSCAPE_DRAFT = 1;
    public static final int RFC2109 = 2;
    private static int defaultPolicy;
    protected static final Log LOG;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookiePolicy;

    public static void registerCookieSpec(String id, CookieSpec spec) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (spec == null) {
            throw new IllegalArgumentException("Cookie spec may not be null");
        }
        SPECS.put(id, spec);
    }

    public static void unregisterCookieSpec(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SPECS.remove(id);
    }

    public static CookieSpec getCookieSpec(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        CookieSpec cookiespec = (CookieSpec)SPECS.get(id);
        if (cookiespec == null) {
            throw new IllegalStateException("Unsupported cookie spec '" + id + "'");
        }
        return cookiespec;
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public static void setDefaultPolicy(int policy) {
        defaultPolicy = policy;
    }

    public static CookieSpec getSpecByPolicy(int policy) {
        switch (policy) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getDefaultSpec() {
        try {
            return CookiePolicy.getCookieSpec(DEFAULT);
        }
        catch (IllegalStateException e) {
            LOG.warn((Object)"Default cookie policy is not registered");
            return new RFC2109Spec();
        }
    }

    public static CookieSpec getSpecByVersion(int ver) {
        switch (ver) {
            case 0: {
                return new NetscapeDraftSpec();
            }
            case 1: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getCompatibilitySpec() {
        return CookiePolicy.getSpecByPolicy(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CookiePolicy.registerCookieSpec(DEFAULT, new RFC2109Spec());
        CookiePolicy.registerCookieSpec(RFC_2109, new RFC2109Spec());
        CookiePolicy.registerCookieSpec(BROWSER_COMPATIBILITY, new CookieSpecBase());
        CookiePolicy.registerCookieSpec(NETSCAPE, new NetscapeDraftSpec());
        CookiePolicy.registerCookieSpec(IGNORE_COOKIES, new IgnoreCookiesSpec());
        defaultPolicy = 2;
        LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$cookie$CookiePolicy == null ? (class$org$apache$commons$httpclient$cookie$CookiePolicy = CookiePolicy.class$("org.apache.commons.httpclient.cookie.CookiePolicy")) : class$org$apache$commons$httpclient$cookie$CookiePolicy));
    }
}

