/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.AbstractEntityLoader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.type.Type;

public class EntityLoader
extends AbstractEntityLoader
implements UniqueEntityLoader {
    private final Type uniqueKeyType;
    private final boolean batchLoader;

    public EntityLoader(OuterJoinLoadable persister, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        this(persister, persister.getIdentifierColumnNames(), persister.getIdentifierType(), batchSize, factory);
    }

    public EntityLoader(OuterJoinLoadable persister, String[] uniqueKey, Type uniqueKeyType, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        super(persister, factory);
        this.uniqueKeyType = uniqueKeyType;
        List associations = this.walkTree(persister, this.getAlias(), factory);
        this.initClassPersisters(associations);
        String whereString = EntityLoader.whereString(this.getAlias(), uniqueKey, batchSize).toString();
        this.renderStatement(associations, whereString, factory);
        this.postInstantiate();
        this.batchLoader = batchSize > 1;
    }

    public Object load(SessionImplementor session, Serializable id, Object optionalObject) throws HibernateException, SQLException {
        return this.load(session, id, optionalObject, id);
    }

    public Object loadByUniqueKey(SessionImplementor session, Serializable id) throws HibernateException, SQLException {
        return this.load(session, id, null, null);
    }

    private Object load(SessionImplementor session, Serializable id, Object optionalObject, Serializable optionalId) throws HibernateException, SQLException {
        List list = this.loadEntity(session, id, this.uniqueKeyType, optionalObject, optionalId);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        if (this.getCollectionOwner() > -1) {
            return list.get(0);
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.getPersister().getClassName());
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row[row.length - 1];
    }

    protected boolean isSingleRowLoader() {
        return !this.batchLoader;
    }
}

