/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hibernate.impl;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;
import org.seasar.hibernate.HibernateRuntimeException;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;
import org.seasar.hibernate.impl.S2SessionImpl;

public final class S2SessionFactoryImpl
implements S2SessionFactory,
Synchronization {
    private TransactionManager transactionManager_;
    private DataSource dataSource_;
    private String configPath_ = "hibernate.cfg.xml";
    private SessionFactory sessionFactory_;
    private Map txSessions_ = new HashMap();

    public S2SessionFactoryImpl(TransactionManager transactionManager, DataSource dataSource) {
        this.transactionManager_ = transactionManager;
        this.dataSource_ = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public String getConfigPath() {
        return this.configPath_;
    }

    public void setConfigPath(String configPath) {
        this.configPath_ = configPath;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory_ != null) {
            return this.sessionFactory_;
        }
        Configuration cfg = new Configuration();
        try {
            cfg.configure(ResourceUtil.getResource((String)this.configPath_));
            this.sessionFactory_ = cfg.buildSessionFactory();
        }
        catch (HibernateException ex) {
            throw new HibernateRuntimeException(ex);
        }
        return this.sessionFactory_;
    }

    public int getTxSessionSize() {
        return this.txSessions_.size();
    }

    public S2Session getSession() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return this.createSession();
        }
        S2Session session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        return this.bindSession(tx);
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.getTransactionManager());
    }

    private S2Session createSession() {
        SessionFactory factory = this.getSessionFactory();
        return new S2SessionImpl(factory.openSession(this.getConnection()));
    }

    private Connection getConnection() {
        return DataSourceUtil.getConnection((DataSource)this.getDataSource());
    }

    private synchronized S2Session bindSession(Transaction tx) {
        S2Session session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        session = this.createSession();
        this.txSessions_.put(tx, session);
        TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)this);
        return session;
    }

    public void beforeCompletion() {
        this.closeSession();
    }

    public void afterCompletion(int arg0) {
    }

    /*
     * Exception decompiling
     */
    private synchronized void closeSession() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 80->84)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

