/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfPopulatingCache
extends BlockingCache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache == null ? (class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache = SelfPopulatingCache.class$("net.sf.ehcache.constructs.blocking.SelfPopulatingCache")) : class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache).getName());
    protected final CacheEntryFactory factory;
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache;

    public SelfPopulatingCache(String name, CacheEntryFactory factory) throws CacheException {
        super(name);
        this.factory = factory;
    }

    public Serializable get(Serializable key) throws CacheException {
        String oldThreadName = Thread.currentThread().getName();
        this.setThreadName("get", key);
        try {
            Serializable value = super.get(key);
            if (value == null) {
                value = this.factory.createEntry(key);
                this.setThreadName("put", key);
                this.put(key, value);
                Thread.currentThread().setName(oldThreadName);
            }
            return value;
        }
        catch (Throwable throwable) {
            this.setThreadName("put", key);
            this.put(key, null);
            Thread.currentThread().setName(oldThreadName);
            throw new CacheException("Could not fetch object for cache entry \"" + key + "\".");
        }
    }

    protected void setThreadName(String method, Serializable key) {
        StringBuffer threadName = new StringBuffer(this.getName()).append(": ").append(method).append("(").append(key).append(")");
        Thread.currentThread().setName(threadName.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws CacheException {
        String oldThreadName = Thread.currentThread().getName();
        Throwable exception = null;
        Collection keys = this.getKeys();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.getName() + ": found " + keys.size() + " keys to refresh"));
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Serializable key = (Serializable)iterator.next();
            try {
                Cache backingCache = this.getCache();
                Element element = backingCache.getQuiet(key);
                if (element == null) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)(this.getName() + ": entry with key " + key + " has been removed - skipping it"));
                    continue;
                }
                this.refreshElement(element, backingCache);
            }
            catch (Exception e) {
                LOG.warn((Object)(this.getName() + "Could not refresh element " + key), (Throwable)e);
                exception = e;
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
        }
        if (exception != null) {
            throw new CacheException(exception.getMessage());
        }
    }

    protected void refreshElement(Element element, Cache backingCache) throws Exception {
        Element replacementElement;
        Serializable key = element.getKey();
        if (LOG.isTraceEnabled()) {
            this.setThreadName("refreshElement", key);
            LOG.trace((Object)(this.getName() + ": refreshing element with key " + key));
        }
        if (this.factory instanceof UpdatingCacheEntryFactory) {
            replacementElement = element;
            ((UpdatingCacheEntryFactory)this.factory).updateEntryValue(key, replacementElement.getValue());
        } else {
            Serializable value = this.factory.createEntry(key);
            replacementElement = new Element(key, value);
        }
        backingCache.putQuiet(replacementElement);
    }

    protected void refreshElement2(Element element, Cache backingCache) throws Exception {
        Serializable key = element.getKey();
        if (LOG.isTraceEnabled()) {
            this.setThreadName("refreshElement", key);
            LOG.trace((Object)(this.getName() + ": refreshing element with key " + key));
        }
        backingCache.putQuiet(element);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

