/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;

public class BasicHandler {
    private DataSource dataSource_;
    private String sql_;

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource_ = dataSource;
    }

    public String getSql() {
        return this.sql_;
    }

    public void setSql(String sql) {
        this.sql_ = sql;
    }

    protected Connection getConnection() {
        if (this.dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return DataSourceUtil.getConnection((DataSource)this.dataSource_);
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        if (this.sql_ == null) {
            throw new EmptyRuntimeException("sql");
        }
        return ConnectionUtil.prepareStatement((Connection)connection, (String)this.sql_);
    }

    protected void bindArgs(PreparedStatement ps, Object[] args) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            ValueType valueType = ValueTypes.getValueType(args[i]);
            try {
                valueType.bindValue(ps, i + 1, args[i]);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
            ++i;
        }
    }

    protected String getCompleteSql(Object[] args) {
        if (args == null || args.length == 0) {
            return this.sql_;
        }
        StringBuffer buf = new StringBuffer(200);
        int pos = 0;
        int pos2 = 0;
        int index = 0;
        while ((pos = this.sql_.indexOf(63, pos2)) > 0) {
            buf.append(this.sql_.substring(pos2, pos));
            buf.append(this.getBindVariableText(args[index++]));
            pos2 = pos + 1;
        }
        buf.append(this.sql_.substring(pos2));
        return buf.toString();
    }

    protected String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return "'" + bindVariable + "'";
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return "null";
        }
        return "'" + bindVariable.toString() + "'";
    }
}

