/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Random;

public class FileUtil {
    public static final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public static final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    static final Method deleteOnExitMethod = FileUtil.getDeleteOnExitMethod();
    static final Random random = new Random(System.currentTimeMillis());
    static /* synthetic */ Class class$java$io$File;

    private static Method getDeleteOnExitMethod() {
        try {
            return (class$java$io$File == null ? (class$java$io$File = FileUtil.class$("java.io.File")) : class$java$io$File).getMethod("deleteOnExit", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void delete(String string) throws IOException {
        try {
            new File(string).delete();
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    public static void deleteOnExit(File file) {
        if (deleteOnExitMethod != null) {
            try {
                deleteOnExitMethod.invoke((Object)file, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean exists(String string) throws IOException {
        try {
            return new File(string).exists();
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    public static void renameOverwrite(String string, String string2) throws IOException {
        try {
            if (FileUtil.exists(string)) {
                FileUtil.delete(string2);
                File file = new File(string);
                file.renameTo(new File(string2));
            }
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.getMessage());
    }

    public static String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public static File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public static File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public static String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public static String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public static String canonicalOrAbsolutePath(String string) {
        try {
            return FileUtil.canonicalPath(string);
        }
        catch (Exception exception) {
            return FileUtil.absolutePath(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

