/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.bean;

import java.lang.reflect.Field;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBeanProvider;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.bean.AbstractBeanInitializer;

public class FieldBeanInitializer
extends AbstractBeanInitializer {
    protected String _fieldName;
    protected Object _fieldValue;
    private boolean _fieldResolved = false;

    public synchronized void setBeanProperty(IBeanProvider provider, Object bean) {
        IResourceResolver resolver = provider.getResourceResolver();
        if (!this._fieldResolved) {
            this.resolveField(resolver);
        }
        this.setBeanProperty(resolver, bean, this._fieldValue);
    }

    private void resolveField(IResourceResolver resolver) {
        if (this._fieldResolved) {
            return;
        }
        int dotx = this._fieldName.lastIndexOf(46);
        if (dotx < 0) {
            throw new ApplicationRuntimeException(Tapestry.format("invalid-field-name", this._fieldName));
        }
        String className = this._fieldName.substring(0, dotx);
        String simpleFieldName = this._fieldName.substring(dotx + 1);
        if (className.indexOf(46) < 0) {
            className = "java.lang." + className;
        }
        Class targetClass = null;
        try {
            targetClass = resolver.findClass(className);
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.format("unable-to-resolve-class", className), t);
        }
        Field field = null;
        try {
            field = targetClass.getField(simpleFieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("field-not-defined", this._fieldName), ex);
        }
        try {
            this._fieldValue = field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("illegal-field-access", this._fieldName), ex);
        }
        catch (NullPointerException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("field-is-instance", this._fieldName), ex);
        }
        this._fieldResolved = true;
    }
}

