/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IComponentClassEnhancer;
import org.apache.tapestry.enhance.CodeGenerationException;
import org.apache.tapestry.enhance.ComponentClassFactory;
import org.apache.tapestry.enhance.IEnhancedClassFactory;
import org.apache.tapestry.enhance.MethodSignature;
import org.apache.tapestry.enhance.javassist.EnhancedClassFactory;
import org.apache.tapestry.spec.IComponentSpecification;

public class DefaultComponentClassEnhancer
implements IComponentClassEnhancer {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$enhance$DefaultComponentClassEnhancer == null ? (class$org$apache$tapestry$enhance$DefaultComponentClassEnhancer = DefaultComponentClassEnhancer.class$("org.apache.tapestry.enhance.DefaultComponentClassEnhancer")) : class$org$apache$tapestry$enhance$DefaultComponentClassEnhancer));
    private Map _cachedClasses = Collections.synchronizedMap(new HashMap());
    private IResourceResolver _resolver;
    private IEnhancedClassFactory _factory;
    private boolean _disableValidation;
    static /* synthetic */ Class class$org$apache$tapestry$enhance$DefaultComponentClassEnhancer;

    public DefaultComponentClassEnhancer(IResourceResolver resolver, boolean disableValidation) {
        this._resolver = resolver;
        this._factory = this.createEnhancedClassFactory();
        this._disableValidation = disableValidation;
    }

    protected IEnhancedClassFactory createEnhancedClassFactory() {
        return new EnhancedClassFactory(this.getResourceResolver());
    }

    public synchronized void reset() {
        this._cachedClasses.clear();
        this._factory.reset();
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getEnhancedClass(IComponentSpecification specification, String className) {
        Class result = this.getCachedClass(specification);
        if (result == null) {
            DefaultComponentClassEnhancer defaultComponentClassEnhancer = this;
            synchronized (defaultComponentClassEnhancer) {
                result = this.getCachedClass(specification);
                if (result == null) {
                    result = this.constructComponentClass(specification, className);
                    this.storeCachedClass(specification, result);
                }
            }
        }
        return result;
    }

    protected void storeCachedClass(IComponentSpecification specification, Class cachedClass) {
        this._cachedClasses.put(specification, cachedClass);
    }

    protected Class getCachedClass(IComponentSpecification specification) {
        return (Class)this._cachedClasses.get(specification);
    }

    protected Class constructComponentClass(IComponentSpecification specification, String className) {
        Class result = null;
        try {
            result = this._resolver.findClass(className);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), specification.getLocation(), ex);
        }
        try {
            ComponentClassFactory factory = this.createComponentClassFactory(specification, result);
            if (factory.needsEnhancement()) {
                result = factory.createEnhancedSubclass();
                if (!this._disableValidation) {
                    this.validateEnhancedClass(result, className, specification);
                }
            }
        }
        catch (CodeGenerationException e) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentClassFactory.code-generation-error", className), e);
        }
        return result;
    }

    protected ComponentClassFactory createComponentClassFactory(IComponentSpecification specification, Class componentClass) {
        return new ComponentClassFactory(this._resolver, specification, componentClass, this._factory);
    }

    protected void validateEnhancedClass(Class subject, String className, IComponentSpecification specification) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Validating " + subject));
        }
        HashSet implementedMethods = new HashSet();
        Class current = subject;
        do {
            Method m;
            if ((m = this.checkForAbstractMethods(current, implementedMethods)) == null) continue;
            throw new ApplicationRuntimeException(Tapestry.format("DefaultComponentClassEnhancer.no-impl-for-abstract-method", new Object[]{m, current, className, subject.getName()}), specification.getLocation(), null);
        } while (Modifier.isAbstract((current = current.getSuperclass()).getModifiers()));
    }

    private Method checkForAbstractMethods(Class current, Set implementedMethods) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Searching for abstract methods in " + current));
        }
        Method[] methods = current.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (debug) {
                LOG.debug((Object)("Checking " + m));
            }
            boolean isAbstract = Modifier.isAbstract(m.getModifiers());
            MethodSignature s = new MethodSignature(m);
            if (isAbstract) {
                if (implementedMethods.contains(s)) continue;
                return m;
            }
            implementedMethods.add(s);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

