/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.html.Body;

public abstract class DatePicker
extends AbstractFormComponent {
    private IScript _script;
    private static final String SYM_NAME = "name";
    private static final String SYM_FORMNAME = "formName";
    private static final String SYM_MONTHNAMES = "monthNames";
    private static final String SYM_SHORT_MONTHNAMES = "shortMonthNames";
    private static final String SYM_WEEKDAYNAMES = "weekDayNames";
    private static final String SYM_SHORT_WEEKDAYNAMES = "shortWeekDayNames";
    private static final String SYM_FIRSTDAYINWEEK = "firstDayInWeek";
    private static final String SYM_MINDAYSINFIRSTWEEK = "minimalDaysInFirstWeek";
    private static final String SYM_FORMAT = "format";
    private static final String SYM_INCL_WEEK = "includeWeek";
    private static final String SYM_VALUE = "value";
    private static final String SYM_BUTTONONCLICKHANDLER = "buttonOnclickHandler";
    private static final String SYM_BUTTONNAME = "buttonName";

    public abstract String getFormat();

    public abstract Date getValue();

    public abstract void setValue(Date var1);

    public abstract boolean isDisabled();

    public abstract boolean getIncludeWeek();

    public abstract IAsset getIcon();

    protected void finishLoad() {
        IEngine engine = this.getPage().getEngine();
        IScriptSource source = engine.getScriptSource();
        IResourceLocation location = this.getSpecification().getSpecificationLocation().getRelativeLocation("DatePicker.script");
        this._script = source.getScript(location);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        String name = form.getElementId(this);
        String format = this.getFormat();
        if (format == null) {
            format = "dd MMM yyyy";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, this.getPage().getLocale());
        boolean disabled = this.isDisabled();
        if (!cycle.isRewinding()) {
            Body body = Body.get(cycle);
            if (body == null) {
                throw new ApplicationRuntimeException(Tapestry.format("must-be-contained-by-body", "DatePicker"), this, null, null);
            }
            Locale locale = this.getPage().getLocale();
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            Calendar cal = Calendar.getInstance(locale);
            Date value = this.getValue();
            HashMap<String, Object> symbols = new HashMap<String, Object>();
            symbols.put(SYM_NAME, name);
            symbols.put(SYM_FORMAT, format);
            symbols.put(SYM_INCL_WEEK, this.getIncludeWeek() ? Boolean.TRUE : Boolean.FALSE);
            symbols.put(SYM_MONTHNAMES, this.makeStringList(dfs.getMonths(), 0, 12));
            symbols.put(SYM_SHORT_MONTHNAMES, this.makeStringList(dfs.getShortMonths(), 0, 12));
            symbols.put(SYM_WEEKDAYNAMES, this.makeStringList(dfs.getWeekdays(), 1, 8));
            symbols.put(SYM_SHORT_WEEKDAYNAMES, this.makeStringList(dfs.getShortWeekdays(), 1, 8));
            symbols.put(SYM_FIRSTDAYINWEEK, new Integer(cal.getFirstDayOfWeek() - 1));
            symbols.put(SYM_MINDAYSINFIRSTWEEK, new Integer(cal.getMinimalDaysInFirstWeek()));
            symbols.put(SYM_FORMNAME, form.getName());
            symbols.put(SYM_VALUE, value);
            this._script.execute(cycle, body, symbols);
            writer.beginEmpty("input");
            writer.attribute("type", "text");
            writer.attribute(SYM_NAME, name);
            writer.attribute("title", formatter.toLocalizedPattern());
            if (value != null) {
                writer.attribute(SYM_VALUE, formatter.format(value));
            }
            if (disabled) {
                writer.attribute("disabled", "disabled");
            }
            this.renderInformalParameters(writer, cycle);
            writer.printRaw("&nbsp;");
            if (!disabled) {
                writer.begin("a");
                writer.attribute("href", (String)symbols.get(SYM_BUTTONONCLICKHANDLER));
            }
            IAsset icon = this.getIcon();
            writer.beginEmpty("img");
            writer.attribute("src", icon.buildURL(cycle));
            writer.attribute("border", 0);
            if (!disabled) {
                writer.end();
            }
        }
        if (form.isRewinding()) {
            if (disabled) {
                return;
            }
            String textValue = cycle.getRequestContext().getParameter(name);
            if (Tapestry.isBlank(textValue)) {
                return;
            }
            try {
                Date value = formatter.parse(textValue);
                this.setValue(value);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
    }

    private String makeStringList(String[] a, int offset, int length) {
        StringBuffer b = new StringBuffer();
        for (int i = offset; i < length; ++i) {
            b.append('\"');
            char[] ch = a[i].toCharArray();
            for (int j = 0; j < ch.length; ++j) {
                if (ch[j] < '\u0080') {
                    b.append(ch[j]);
                    continue;
                }
                b.append(DatePicker.escape(ch[j]));
            }
            b.append('\"');
            if (i >= length - 1) continue;
            b.append(", ");
        }
        return b.toString();
    }

    private static String escape(char c) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            b.append(Integer.toHexString(c & 0xF).toUpperCase());
            c = (char)(c >>> 4);
        }
        b.append("u\\");
        return b.reverse().toString();
    }
}

