/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.IPropertySelectionRenderer;
import org.apache.tapestry.form.RadioPropertySelectionRenderer;
import org.apache.tapestry.form.SelectPropertySelectionRenderer;

public abstract class PropertySelection
extends AbstractFormComponent {
    public static final IPropertySelectionRenderer DEFAULT_SELECT_RENDERER = new SelectPropertySelectionRenderer();
    public static final IPropertySelectionRenderer DEFAULT_RADIO_RENDERER = new RadioPropertySelectionRenderer();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        String name = form.getElementId(this);
        if (rewinding) {
            if (this.isDisabled()) {
                return;
            }
            String optionValue = cycle.getRequestContext().getParameter(name);
            Object value = optionValue == null ? null : this.getModel().translateValue(optionValue);
            this.setValue(value);
            return;
        }
        IPropertySelectionRenderer renderer = this.getRenderer();
        if (renderer != null) {
            this.renderWithRenderer(writer, cycle, renderer);
            return;
        }
        writer.begin("select");
        writer.attribute("name", name);
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        if (this.getSubmitOnChange()) {
            writer.attribute("onchange", "javascript:this.form.submit();");
        }
        this.renderInformalParameters(writer, cycle);
        writer.println();
        IPropertySelectionModel model = this.getModel();
        if (model == null) {
            throw Tapestry.createRequiredParameterException(this, "model");
        }
        int count = model.getOptionCount();
        boolean foundSelected = false;
        boolean selected = false;
        Object value = this.getValue();
        for (int i = 0; i < count; ++i) {
            Object option = model.getOption(i);
            if (!foundSelected && (selected = this.isEqual(option, value))) {
                foundSelected = true;
            }
            writer.begin("option");
            writer.attribute("value", model.getValue(i));
            if (selected) {
                writer.attribute("selected", "selected");
            }
            writer.print(model.getLabel(i));
            writer.end();
            writer.println();
            selected = false;
        }
        writer.end();
    }

    private void renderWithRenderer(IMarkupWriter writer, IRequestCycle cycle, IPropertySelectionRenderer renderer) {
        renderer.beginRender(this, writer, cycle);
        IPropertySelectionModel model = this.getModel();
        int count = model.getOptionCount();
        boolean foundSelected = false;
        boolean selected = false;
        Object value = this.getValue();
        for (int i = 0; i < count; ++i) {
            Object option = model.getOption(i);
            if (!foundSelected && (selected = this.isEqual(option, value))) {
                foundSelected = true;
            }
            renderer.renderOption(this, writer, cycle, model, option, i, selected);
            selected = false;
        }
        renderer.endRender(this, writer, cycle);
    }

    private boolean isEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public abstract IPropertySelectionModel getModel();

    public abstract IPropertySelectionRenderer getRenderer();

    public abstract boolean getSubmitOnChange();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract boolean isDisabled();
}

