/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import org.apache.commons.lang.enum.Enum;
import org.apache.tapestry.IMarkupWriter;

public abstract class InsertTextMode
extends Enum {
    public static final InsertTextMode BREAK = new BreakMode();
    public static final InsertTextMode PARAGRAPH = new ParagraphMode();

    protected InsertTextMode(String name) {
        super(name);
    }

    public abstract void writeLine(int var1, String var2, IMarkupWriter var3);

    private static class ParagraphMode
    extends InsertTextMode {
        private ParagraphMode() {
            super("PARAGRAPH");
        }

        public void writeLine(int lineNumber, String line, IMarkupWriter writer) {
            writer.begin("p");
            writer.print(line);
            writer.end();
        }
    }

    private static class BreakMode
    extends InsertTextMode {
        private BreakMode() {
            super("BREAK");
        }

        public void writeLine(int lineNumber, String line, IMarkupWriter writer) {
            if (lineNumber > 0) {
                writer.beginEmpty("br");
            }
            writer.print(line);
        }
    }
}

