/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationServlet;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.multipart.DefaultMultipartDecoder;
import org.apache.tapestry.multipart.IMultipartDecoder;
import org.apache.tapestry.request.DecodedRequest;
import org.apache.tapestry.request.IRequestDecoder;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.util.IRenderDescription;

public class RequestContext
implements IRender {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$request$RequestContext == null ? (class$org$apache$tapestry$request$RequestContext = RequestContext.class$("org.apache.tapestry.request.RequestContext")) : class$org$apache$tapestry$request$RequestContext));
    private HttpSession _session;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ApplicationServlet _servlet;
    private DecodedRequest _decodedRequest;
    private IMultipartDecoder _decoder;
    private boolean _decoded;
    private Map _cookieMap;
    private boolean _evenRow;
    static /* synthetic */ Class class$org$apache$tapestry$request$RequestContext;
    static /* synthetic */ Class class$org$apache$tapestry$multipart$IMultipartDecoder;
    static /* synthetic */ Class class$org$apache$tapestry$request$IRequestDecoder;

    public RequestContext(ApplicationServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._servlet = servlet;
        this._request = request;
        this._response = response;
        if (this._request != null && DefaultMultipartDecoder.isMultipartRequest(request)) {
            IMultipartDecoder decoder = this.obtainMultipartDecoder(servlet, request);
            this.setDecoder(decoder);
        }
    }

    protected IMultipartDecoder obtainMultipartDecoder(ApplicationServlet servlet, HttpServletRequest request) throws IOException {
        IApplicationSpecification spec = servlet.getApplicationSpecification();
        if (spec.checkExtension("org.apache.tapestry.multipart-decoder")) {
            return (IMultipartDecoder)spec.getExtension("org.apache.tapestry.multipart-decoder", class$org$apache$tapestry$multipart$IMultipartDecoder == null ? (class$org$apache$tapestry$multipart$IMultipartDecoder = RequestContext.class$("org.apache.tapestry.multipart.IMultipartDecoder")) : class$org$apache$tapestry$multipart$IMultipartDecoder);
        }
        return DefaultMultipartDecoder.getSharedInstance();
    }

    public void addCookie(String name, String value) {
        this.addCookie(new Cookie(name, value));
    }

    public void addCookie(Cookie cookie) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding cookie " + cookie));
        }
        this._response.addCookie(cookie);
        if (this._cookieMap == null) {
            this.readCookieMap();
        }
        this._cookieMap.put(cookie.getName(), cookie);
    }

    private void datePair(IMarkupWriter writer, String name, long value) {
        this.pair(writer, name, new Date(value));
    }

    private DecodedRequest getDecodedRequest() {
        if (this._decodedRequest != null) {
            return this._decodedRequest;
        }
        IApplicationSpecification spec = this._servlet.getApplicationSpecification();
        IRequestDecoder decoder = null;
        decoder = !spec.checkExtension("org.apache.tapestry.request-decoder") ? new DefaultRequestDecoder() : (IRequestDecoder)spec.getExtension("org.apache.tapestry.request-decoder", class$org$apache$tapestry$request$IRequestDecoder == null ? (class$org$apache$tapestry$request$IRequestDecoder = RequestContext.class$("org.apache.tapestry.request.IRequestDecoder")) : class$org$apache$tapestry$request$IRequestDecoder);
        this._decodedRequest = decoder.decodeRequest(this._request);
        return this._decodedRequest;
    }

    public String getScheme() {
        return this.getDecodedRequest().getScheme();
    }

    public String getServerName() {
        return this.getDecodedRequest().getServerName();
    }

    public int getServerPort() {
        return this.getDecodedRequest().getServerPort();
    }

    public String getRequestURI() {
        return this.getDecodedRequest().getRequestURI();
    }

    public String getAbsoluteURL(String URI2) {
        String scheme = this.getScheme();
        String server = this.getServerName();
        int port = this.getServerPort();
        if (scheme.equals("http") && port == 80) {
            port = 0;
        }
        return this.getAbsoluteURL(URI2, scheme, server, port);
    }

    public String getAbsoluteURL(String URI2, String scheme, String server, int port) {
        StringBuffer buffer = new StringBuffer();
        if (URI2.indexOf(58) >= 0) {
            return URI2;
        }
        if (URI2.substring(0, 1).equals("//")) {
            buffer.append(scheme);
            buffer.append(':');
            buffer.append(URI2);
            return buffer.toString();
        }
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(server);
        if (port > 0) {
            buffer.append(':');
            buffer.append(port);
        }
        if (URI2.charAt(0) != '/') {
            buffer.append('/');
        }
        buffer.append(URI2);
        return buffer.toString();
    }

    public Cookie getCookie(String name) {
        if (this._cookieMap == null) {
            this.readCookieMap();
        }
        return (Cookie)this._cookieMap.get(name);
    }

    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String getParameter(String name) {
        IMultipartDecoder decoder = this.getDecoder();
        if (decoder != null) {
            return decoder.getString(this._request, name);
        }
        return this._request.getParameter(name);
    }

    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    public String[] getParameters(String name) {
        IMultipartDecoder decoder = this.getDecoder();
        if (decoder != null) {
            return decoder.getStrings(this._request, name);
        }
        return this._request.getParameterValues(name);
    }

    public IUploadFile getUploadFile(String name) {
        IMultipartDecoder decoder = this.getDecoder();
        if (decoder == null) {
            return null;
        }
        return decoder.getUploadFile(this._request, name);
    }

    public void cleanup() {
        if (this._decoder != null) {
            this._decoder.cleanup(this._request);
        }
    }

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    private String getRowClass() {
        String result = this._evenRow ? "even" : "odd";
        this._evenRow = !this._evenRow;
        return result;
    }

    public ApplicationServlet getServlet() {
        return this._servlet;
    }

    public HttpSession getSession() {
        if (this._session == null) {
            this._session = this._request.getSession(false);
        }
        return this._session;
    }

    public HttpSession createSession() {
        if (this._session == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Creating HttpSession");
            }
            this._session = this._request.getSession(true);
        }
        return this._session;
    }

    private void header(IMarkupWriter writer, String valueName, String dataName) {
        writer.begin("tr");
        writer.attribute("class", "request-context-header");
        writer.begin("th");
        writer.print(valueName);
        writer.end();
        writer.begin("th");
        writer.print(dataName);
        writer.end("tr");
        this._evenRow = true;
    }

    private void object(IMarkupWriter writer, String objectName) {
        writer.begin("span");
        writer.attribute("class", "request-context-object");
        writer.print(objectName);
        writer.end();
    }

    private void pair(IMarkupWriter writer, String name, int value) {
        this.pair(writer, name, Integer.toString(value));
    }

    private void pair(IMarkupWriter writer, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof IRenderDescription) {
            IRenderDescription renderValue = (IRenderDescription)value;
            writer.begin("tr");
            writer.attribute("class", this.getRowClass());
            writer.begin("th");
            writer.print(name);
            writer.end();
            writer.begin("td");
            renderValue.renderDescription(writer);
            writer.end("tr");
            writer.println();
            return;
        }
        this.pair(writer, name, value.toString());
    }

    private void pair(IMarkupWriter writer, String name, String value) {
        if (value == null) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        writer.begin("tr");
        writer.attribute("class", this.getRowClass());
        writer.begin("th");
        writer.print(name);
        writer.end();
        writer.begin("td");
        writer.print(value);
        writer.end("tr");
        writer.println();
    }

    private void pair(IMarkupWriter writer, String name, boolean value) {
        this.pair(writer, name, value ? "yes" : "no");
    }

    private void readCookieMap() {
        this._cookieMap = new HashMap();
        Cookie[] cookies = this._request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this._cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
    }

    public void redirect(String path) throws IOException {
        String absolutePath = this.getAbsoluteURL(path);
        String encodedURL = this._response.encodeRedirectURL(absolutePath);
        this._response.sendRedirect(encodedURL);
    }

    private void section(IMarkupWriter writer, String sectionName) {
        writer.begin("tr");
        writer.attribute("class", "request-context-section");
        writer.begin("th");
        writer.attribute("colspan", 2);
        writer.print(sectionName);
        writer.end("tr");
    }

    private List getSorted(Enumeration e) {
        ArrayList result = new ArrayList();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        Collections.sort(result);
        return result;
    }

    public void write(IMarkupWriter writer) {
        String name;
        int i;
        String name2;
        int i2;
        int count;
        writer.begin("table");
        writer.attribute("class", "request-context-border");
        writer.begin("tr");
        writer.begin("td");
        HttpSession session = this.getSession();
        if (session != null) {
            this.object(writer, "Session");
            writer.begin("table");
            writer.attribute("class", "request-context-object");
            this.section(writer, "Properties");
            this.header(writer, "Name", "Value");
            this.pair(writer, "id", session.getId());
            this.datePair(writer, "creationTime", session.getCreationTime());
            this.datePair(writer, "lastAccessedTime", session.getLastAccessedTime());
            this.pair(writer, "maxInactiveInterval", session.getMaxInactiveInterval());
            this.pair(writer, "new", session.isNew());
            List names = this.getSorted(session.getAttributeNames());
            count = names.size();
            for (i2 = 0; i2 < count; ++i2) {
                if (i2 == 0) {
                    this.section(writer, "Attributes");
                    this.header(writer, "Name", "Value");
                }
                name2 = (String)names.get(i2);
                this.pair(writer, name2, session.getAttribute(name2));
            }
            writer.end();
        }
        this.object(writer, "Request");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        List parameters = this.getSorted(this._request.getParameterNames());
        count = parameters.size();
        for (i2 = 0; i2 < count; ++i2) {
            if (i2 == 0) {
                this.section(writer, "Parameters");
                this.header(writer, "Name", "Value(s)");
            }
            name2 = (String)parameters.get(i2);
            String[] values = this._request.getParameterValues(name2);
            writer.begin("tr");
            writer.attribute("class", this.getRowClass());
            writer.begin("th");
            writer.print(name2);
            writer.end();
            writer.begin("td");
            if (values.length > 1) {
                writer.begin("ul");
            }
            for (int j = 0; j < values.length; ++j) {
                if (values.length > 1) {
                    writer.beginEmpty("li");
                }
                writer.print(values[j]);
            }
            writer.end("tr");
        }
        this.section(writer, "Properties");
        this.header(writer, "Name", "Value");
        this.pair(writer, "authType", this._request.getAuthType());
        this.pair(writer, "characterEncoding", this._request.getCharacterEncoding());
        this.pair(writer, "contentLength", this._request.getContentLength());
        this.pair(writer, "contentType", this._request.getContentType());
        this.pair(writer, "method", this._request.getMethod());
        this.pair(writer, "pathInfo", this._request.getPathInfo());
        this.pair(writer, "pathTranslated", this._request.getPathTranslated());
        this.pair(writer, "protocol", this._request.getProtocol());
        this.pair(writer, "queryString", this._request.getQueryString());
        this.pair(writer, "remoteAddr", this._request.getRemoteAddr());
        this.pair(writer, "remoteHost", this._request.getRemoteHost());
        this.pair(writer, "remoteUser", this._request.getRemoteUser());
        this.pair(writer, "requestedSessionId", this._request.getRequestedSessionId());
        this.pair(writer, "requestedSessionIdFromCookie", this._request.isRequestedSessionIdFromCookie());
        this.pair(writer, "requestedSessionIdFromURL", this._request.isRequestedSessionIdFromURL());
        this.pair(writer, "requestedSessionIdValid", this._request.isRequestedSessionIdValid());
        this.pair(writer, "requestURI", this._request.getRequestURI());
        this.pair(writer, "scheme", this._request.getScheme());
        this.pair(writer, "serverName", this._request.getServerName());
        this.pair(writer, "serverPort", this._request.getServerPort());
        this.pair(writer, "contextPath", this._request.getContextPath());
        this.pair(writer, "servletPath", this._request.getServletPath());
        List headers = this.getSorted(this._request.getHeaderNames());
        count = headers.size();
        for (int i3 = 0; i3 < count; ++i3) {
            if (i3 == 0) {
                this.section(writer, "Headers");
                this.header(writer, "Name", "Value");
            }
            String name3 = (String)headers.get(i3);
            String value = this._request.getHeader(name3);
            this.pair(writer, name3, value);
        }
        List attributes = this.getSorted(this._request.getAttributeNames());
        count = attributes.size();
        for (int i4 = 0; i4 < count; ++i4) {
            if (i4 == 0) {
                this.section(writer, "Attributes");
                this.header(writer, "Name", "Value");
            }
            String name4 = (String)attributes.get(i4);
            this.pair(writer, name4, this._request.getAttribute(name4));
        }
        Cookie[] cookies = this._request.getCookies();
        if (cookies != null) {
            for (int i5 = 0; i5 < cookies.length; ++i5) {
                if (i5 == 0) {
                    this.section(writer, "Cookies");
                    this.header(writer, "Name", "Value");
                }
                Cookie cookie = cookies[i5];
                this.pair(writer, cookie.getName(), cookie.getValue());
            }
        }
        writer.end();
        this.object(writer, "Servlet");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        this.section(writer, "Properties");
        this.header(writer, "Name", "Value");
        this.pair(writer, "servlet", (Object)this._servlet);
        this.pair(writer, "name", this._servlet.getServletName());
        this.pair(writer, "servletInfo", this._servlet.getServletInfo());
        ServletConfig config = this._servlet.getServletConfig();
        List names = this.getSorted(config.getInitParameterNames());
        count = names.size();
        for (int i6 = 0; i6 < count; ++i6) {
            if (i6 == 0) {
                this.section(writer, "Init Parameters");
                this.header(writer, "Name", "Value");
            }
            String name5 = (String)names.get(i6);
            this.pair(writer, name5, config.getInitParameter(name5));
        }
        writer.end();
        ServletContext context = config.getServletContext();
        this.object(writer, "Servlet Context");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        this.section(writer, "Properties");
        this.header(writer, "Name", "Value");
        this.pair(writer, "majorVersion", context.getMajorVersion());
        this.pair(writer, "minorVersion", context.getMinorVersion());
        this.pair(writer, "serverInfo", context.getServerInfo());
        names = this.getSorted(context.getInitParameterNames());
        count = names.size();
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                this.section(writer, "Initial Parameters");
                this.header(writer, "Name", "Value");
            }
            name = (String)names.get(i);
            this.pair(writer, name, context.getInitParameter(name));
        }
        names = this.getSorted(context.getAttributeNames());
        count = names.size();
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                this.section(writer, "Attributes");
                this.header(writer, "Name", "Value");
            }
            name = (String)names.get(i);
            this.pair(writer, name, context.getAttribute(name));
        }
        writer.end();
        this.writeSystemProperties(writer);
        writer.end("table");
    }

    private void writeSystemProperties(IMarkupWriter writer) {
        Properties properties = null;
        this.object(writer, "JVM System Properties");
        try {
            properties = System.getProperties();
        }
        catch (SecurityException se) {
            writer.print("<p>");
            writer.print(se.toString());
            return;
        }
        String pathSeparator = System.getProperty("path.separator", ";");
        writer.begin("table");
        writer.attribute("class", "request-context-object");
        ArrayList names = new ArrayList(((Hashtable)properties).keySet());
        Collections.sort(names);
        int count = names.size();
        for (int i = 0; i < count; ++i) {
            String name;
            String property;
            if (i == 0) {
                this.header(writer, "Name", "Value");
            }
            if ((property = properties.getProperty(name = (String)names.get(i))) != null && property.indexOf(pathSeparator) > 0 && name.endsWith(".path")) {
                writer.begin("tr");
                writer.attribute("class", this.getRowClass());
                writer.begin("th");
                writer.print(name);
                writer.end();
                writer.begin("td");
                writer.begin("ul");
                StringTokenizer tokenizer = new StringTokenizer(property, pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    writer.beginEmpty("li");
                    writer.print(tokenizer.nextToken());
                }
                writer.end("tr");
                continue;
            }
            this.pair(writer, name, property);
        }
        writer.end();
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) {
        if (!cycle.isRewinding()) {
            this.write(writer);
        }
    }

    private IMultipartDecoder getDecoder() {
        if (this._decoder != null && !this._decoded) {
            this._decoder.decode(this._request);
            this._decoded = true;
        }
        return this._decoder;
    }

    public void setDecoder(IMultipartDecoder decoder) {
        this._decoder = decoder;
        this._decoded = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DefaultRequestDecoder
    implements IRequestDecoder {
        private DefaultRequestDecoder() {
        }

        public DecodedRequest decodeRequest(HttpServletRequest request) {
            DecodedRequest result = new DecodedRequest();
            result.setRequestURI(request.getRequestURI());
            result.setScheme(request.getScheme());
            result.setServerName(request.getServerName());
            result.setServerPort(request.getServerPort());
            return result;
        }
    }
}

