/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.script;

import org.apache.tapestry.ILocation;
import org.apache.tapestry.script.IScriptToken;
import org.apache.tapestry.script.InsertToken;
import org.apache.tapestry.script.StaticToken;
import org.apache.tapestry.util.xml.BaseRule;
import org.apache.tapestry.util.xml.RuleDirectedParser;

abstract class AbstractTokenRule
extends BaseRule {
    private static final int STATE_START = 0;
    private static final int STATE_DOLLAR = 1;
    private static final int STATE_COLLECT_EXPRESSION = 2;

    AbstractTokenRule() {
    }

    protected void addToParent(RuleDirectedParser parser, IScriptToken token) {
        IScriptToken parent = (IScriptToken)parser.peek();
        parent.addToken(token);
    }

    public void content(RuleDirectedParser parser, String content) {
        IScriptToken token = (IScriptToken)parser.peek();
        this.addTextTokens(token, content, parser.getLocation());
    }

    protected void addTextTokens(IScriptToken token, String text, ILocation location) {
        char[] buffer = text.toCharArray();
        int state = 0;
        int blockStart = 0;
        int blockLength = 0;
        int expressionStart = -1;
        int expressionLength = 0;
        int i = 0;
        int braceDepth = 0;
        block5: while (i < buffer.length) {
            char ch = buffer[i];
            switch (state) {
                case 0: {
                    if (ch == '$') {
                        state = 1;
                        ++i;
                        continue block5;
                    }
                    ++blockLength;
                    ++i;
                    continue block5;
                }
                case 1: {
                    if (ch == '{') {
                        state = 2;
                        expressionStart = ++i;
                        expressionLength = 0;
                        braceDepth = 1;
                        continue block5;
                    }
                    ++blockLength;
                    state = 0;
                    continue block5;
                }
                case 2: {
                    if (ch != '}') {
                        if (ch == '{') {
                            ++braceDepth;
                        }
                        ++i;
                        ++expressionLength;
                        continue block5;
                    }
                    if (--braceDepth > 0) {
                        ++i;
                        ++expressionLength;
                        continue block5;
                    }
                    if (expressionLength == 0) {
                        blockLength += 3;
                    }
                    if (blockLength > 0) {
                        token.addToken(this.constructStatic(text, blockStart, blockLength, location));
                    }
                    if (expressionLength > 0) {
                        String expression = text.substring(expressionStart, expressionStart + expressionLength);
                        token.addToken(new InsertToken(expression, location));
                    }
                    blockStart = ++i;
                    blockLength = 0;
                    state = 0;
                    continue block5;
                }
            }
        }
        if (state == 1) {
            ++blockLength;
        }
        if (state == 2) {
            blockLength += expressionLength + 2;
        }
        if (blockLength > 0) {
            token.addToken(this.constructStatic(text, blockStart, blockLength, location));
        }
    }

    private IScriptToken constructStatic(String text, int blockStart, int blockLength, ILocation location) {
        String literal = text.substring(blockStart, blockStart + blockLength);
        return new StaticToken(literal, location);
    }
}

