/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;

public class DefaultResourceResolver
implements IResourceResolver {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$util$DefaultResourceResolver == null ? (class$org$apache$tapestry$util$DefaultResourceResolver = DefaultResourceResolver.class$("org.apache.tapestry.util.DefaultResourceResolver")) : class$org$apache$tapestry$util$DefaultResourceResolver));
    private ClassLoader _loader;
    static /* synthetic */ Class class$org$apache$tapestry$util$DefaultResourceResolver;

    public DefaultResourceResolver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DefaultResourceResolver(ClassLoader loader) {
        this._loader = loader;
    }

    public URL getResource(String name) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("getResource(" + name + ")"));
        }
        String stripped = this.removeLeadingSlash(name);
        URL result = this._loader.getResource(stripped);
        if (debug) {
            if (result == null) {
                LOG.debug((Object)"Not found.");
            } else {
                LOG.debug((Object)("Found as " + result));
            }
        }
        return result;
    }

    private String removeLeadingSlash(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    public Class findClass(String name) {
        try {
            return Class.forName(name, true, this._loader);
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.format("ResourceResolver.unable-to-load-class", name, this._loader, t.getMessage()), t);
        }
    }

    public Class classForName(String name, Map map) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

