/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.pool;

import org.apache.tapestry.util.pool.Pool;

class PoolList {
    private Pool _pool;
    private Entry _first;
    private Entry _spare;
    private int _count;

    PoolList(Pool pool) {
        this._pool = pool;
    }

    public int getPooledCount() {
        return this._count;
    }

    public Object retrieve() {
        if (this._count == 0) {
            return null;
        }
        --this._count;
        Entry e = this._first;
        Object result = e.pooled;
        this._first = e.next;
        e.next = this._spare;
        this._spare = e;
        e.generation = 0;
        e.pooled = null;
        return result;
    }

    public int store(int generation, Object object) {
        Entry e;
        if (this._spare == null) {
            e = new Entry();
        } else {
            e = this._spare;
            this._spare = this._spare.next;
        }
        e.generation = generation;
        e.pooled = object;
        e.next = this._first;
        this._first = e;
        return ++this._count;
    }

    public int cleanup(int generation) {
        this._spare = null;
        this._count = 0;
        Entry prev = null;
        Entry e = this._first;
        while (e != null) {
            if (e.generation <= generation) {
                Object pooled = e.pooled;
                this._pool.getAdaptor(pooled).discardFromPool(pooled);
                if (prev == null) {
                    this._first = null;
                } else {
                    prev.next = null;
                }
            } else {
                ++this._count;
            }
            prev = e;
            e = e.next;
        }
        return this._count;
    }

    public String toString() {
        return "PoolList[" + this._count + "]";
    }

    void discardAll() {
        Entry e = this._first;
        while (e != null) {
            Object pooled = e.pooled;
            this._pool.getAdaptor(pooled).discardFromPool(pooled);
            e = e.next;
        }
        this._first = null;
        this._spare = null;
        this._count = 0;
    }

    private static class Entry {
        int generation;
        Object pooled;
        Entry next;

        private Entry() {
        }
    }
}

