/*
 * 쐬F 2004/09/07
 */
package org.seasar.tapestry.util;

import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.tapestry.page.translation.BeanCopy;

/**
 * @author maruo_syunsuke
 */
public class InjectionUtil {
    private static final Log LOG = LogFactory.getLog(BeanCopy.class);

    InjectionUtil() {}
	
    public static void invokeSetterInjection( Object target ) {
        S2Container container = SingletonS2ContainerFactory.getContainer().getRoot();
        Method[] methods = target.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            if ( isInjectionableMethod(container,method) == false ) continue;
            doInjection(container,target,method);
        }
    }
	public static void invokeSetterInjection( Class runClass, Object target ) {
        S2Container container = SingletonS2ContainerFactory.getContainer().getRoot();
		Method[] methods = runClass.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			Method method = methods[i];
			if ( isInjectionableMethod(container,method) == false ) continue;
			doInjection(container,target,method);
		}
	}
    private static void doInjection(S2Container container,Object target, Method method){
        try {
            Class[] classes = method.getParameterTypes();
            Class clazz = classes[0];
            Object injectObject = container.getComponent(clazz);
            if (injectObject == null) return ;
            method.invoke(target, new Object[] { injectObject });
            if( LOG.isDebugEnabled()){
                LOG.debug( "Injection : " + method.getName() + "(" + 
                    injectObject.getClass().getName() + "::" + 
                    injectObject.toString() + ")" );
            }
        } catch (Exception e) {
        }
    }
    private static boolean isInjectionableMethod(S2Container container,Method method){
        if( AccessaUtil.isSetterMethod(method) == false ) return false ; 
        Class[] classes = method.getParameterTypes();
        Class clazz = classes[0];
        if (clazz.isPrimitive()) return false ;
        if (container.hasComponentDef(clazz) == false) return false ;
        return true ;
    }
}