package test.org.seasar.extension.openamf.invoke;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 *
 * @author Hidetoshi Hosokawa
 */
public class BeanDebugger {

	public static void dump(Object object) {

		try {
			Class clazz = object.getClass();
			Field[] fields = clazz.getDeclaredFields();

			if (fields == null) {
				return;
			}

			System.out.println("-----dump start------");
			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				String fieldName = field.getName();
				String methodName = getGetterName(fieldName);

				Method method = clazz.getMethod(methodName, null);
				Object result = method.invoke(object, null);
				
				System.out.println(fieldName + " F " + result);
			}
			System.out.println("-----dump end------");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private static String getGetterName(String methodName) {
		String buff = "get";
		buff += methodName.substring(0, 1).toUpperCase();
		buff += methodName.substring(1);
		return buff;
	}
}
