/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;

public abstract class RFC2617Scheme
implements AuthScheme {
    private Map params = null;

    public RFC2617Scheme() {
    }

    public RFC2617Scheme(String challenge) throws MalformedChallengeException {
        this.processChallenge(challenge);
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s = AuthChallengeParser.extractScheme(challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid " + this.getSchemeName() + " challenge: " + challenge);
        }
        this.params = AuthChallengeParser.extractParams(challenge);
    }

    protected Map getParameters() {
        return this.params;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        if (this.params == null) {
            return null;
        }
        return (String)this.params.get(name.toLowerCase());
    }

    public String getRealm() {
        return this.getParameter("realm");
    }

    public String getID() {
        return this.getRealm();
    }

    public abstract /* synthetic */ String authenticate(Credentials var1, HttpMethod var2) throws AuthenticationException;

    public abstract /* synthetic */ String authenticate(Credentials var1, String var2, String var3) throws AuthenticationException;

    public abstract /* synthetic */ boolean isComplete();

    public abstract /* synthetic */ boolean isConnectionBased();

    public abstract /* synthetic */ String getSchemeName();
}

