package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ResultSetFactory;

/**
 * @author higa
 *  
 */
public class DaoMetaDataFactoryImpl implements DaoMetaDataFactory {

	private Map daoMetaDataCache_ = new HashMap();

	private DataSource dataSource_;
	
	private StatementFactory statementFactory_;

	private ResultSetFactory resultSetFactory_;

	public DaoMetaDataFactoryImpl(DataSource dataSource,
			StatementFactory statementFactory,
			ResultSetFactory resultSetFactory) {
		
		dataSource_ = dataSource;
		statementFactory_ = statementFactory;
		resultSetFactory_ = resultSetFactory;
	}

	public synchronized DaoMetaData getDaoMetaData(Class daoClass) {
		String key = daoClass.getName();
		DaoMetaData dmd = (DaoMetaData) daoMetaDataCache_.get(key);
		if (dmd != null) {
			return dmd;
		}
		dmd = new DaoMetaDataImpl(daoClass, dataSource_, statementFactory_, resultSetFactory_);
		daoMetaDataCache_.put(key, dmd);
		return dmd;
	}
}