/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.asm;

import com.tonicsystems.jarjar.asm.ByteVector;
import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.asm.ClassWriter;
import com.tonicsystems.jarjar.asm.Label;

public class Attribute {
    public final String type;
    public Attribute next;

    protected Attribute(String type) {
        this.type = type;
    }

    public boolean isUnknown() {
        return this.getClass().getName().equals("com.tonicsystems.jarjar.asm.Attribute");
    }

    protected Label[] getLabels() {
        return null;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        return new Attribute(this.type);
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        return new ByteVector();
    }

    final int getCount() {
        int count = 0;
        Attribute attr = this;
        while (attr != null) {
            ++count;
            attr = attr.next;
        }
        return count;
    }

    final int getSize(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        int size = 0;
        Attribute attr = this;
        while (attr != null) {
            ByteVector b = attr.write(cw, code, len, maxStack, maxLocals);
            if (b.length > 0) {
                cw.newUTF8(attr.type);
                size += b.length + 6;
            }
            attr = attr.next;
        }
        return size;
    }

    final void put(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals, ByteVector out) {
        if (this.next != null) {
            this.next.put(cw, code, len, maxStack, maxLocals, out);
        }
        ByteVector b = this.write(cw, code, len, maxStack, maxLocals);
        if (b.length == 0) {
            if (cw.checkAttributes) {
                throw new IllegalArgumentException("Unknown attribute type " + this.type);
            }
        } else {
            out.putShort(cw.newUTF8(this.type)).putInt(b.length);
            out.putByteArray(b.data, 0, b.length);
        }
    }
}

