/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.asm;

import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.ByteVector;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.asm.CodeVisitor;
import com.tonicsystems.jarjar.asm.CodeWriter;
import com.tonicsystems.jarjar.asm.Item;
import com.tonicsystems.jarjar.asm.Type;

public class ClassWriter
implements ClassVisitor {
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    private int version;
    private short index = 1;
    private ByteVector pool = new ByteVector();
    private Item[] items = new Item[64];
    private int threshold = (int)(0.75 * (double)this.items.length);
    private int access;
    private int name;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    private int sourceFile;
    private int fieldCount;
    private ByteVector fields;
    private boolean computeMaxs;
    boolean checkAttributes;
    CodeWriter firstMethod;
    CodeWriter lastMethod;
    private int innerClassesCount;
    private ByteVector innerClasses;
    private Attribute attrs;
    Item key = new Item();
    Item key2 = new Item();
    Item key3 = new Item();
    static final int NOARG_INSN = 0;
    static final int SBYTE_INSN = 1;
    static final int SHORT_INSN = 2;
    static final int VAR_INSN = 3;
    static final int IMPLVAR_INSN = 4;
    static final int TYPE_INSN = 5;
    static final int FIELDORMETH_INSN = 6;
    static final int ITFMETH_INSN = 7;
    static final int LABEL_INSN = 8;
    static final int LABELW_INSN = 9;
    static final int LDC_INSN = 10;
    static final int LDCW_INSN = 11;
    static final int IINC_INSN = 12;
    static final int TABL_INSN = 13;
    static final int LOOK_INSN = 14;
    static final int MANA_INSN = 15;
    static final int WIDE_INSN = 16;
    static byte[] TYPE;

    public ClassWriter(boolean computeMaxs) {
        this(computeMaxs, false);
    }

    public ClassWriter(boolean computeMaxs, boolean skipUnknownAttributes) {
        this.computeMaxs = computeMaxs;
        this.checkAttributes = !skipUnknownAttributes;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.version = version;
        this.access = access;
        this.name = this.newClass(name);
        int n = this.superName = superName == null ? 0 : this.newClass(superName);
        if (interfaces != null && interfaces.length > 0) {
            this.interfaceCount = interfaces.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.newClass(interfaces[i]);
            }
        }
        if (sourceFile != null) {
            this.newUTF8("SourceFile");
            this.sourceFile = this.newUTF8(sourceFile);
        }
        if ((access & 0x20000) != 0) {
            this.newUTF8("Deprecated");
        }
        if ((access & 0x1000) != 0) {
            this.newUTF8("Synthetic");
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.innerClasses == null) {
            this.newUTF8("InnerClasses");
            this.innerClasses = new ByteVector();
        }
        ++this.innerClassesCount;
        this.innerClasses.putShort(name == null ? 0 : this.newClass(name));
        this.innerClasses.putShort(outerName == null ? 0 : this.newClass(outerName));
        this.innerClasses.putShort(innerName == null ? 0 : this.newUTF8(innerName));
        this.innerClasses.putShort(access);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        ++this.fieldCount;
        if (this.fields == null) {
            this.fields = new ByteVector();
        }
        this.fields.putShort(access).putShort(this.newUTF8(name)).putShort(this.newUTF8(desc));
        int attributeCount = 0;
        if (value != null) {
            ++attributeCount;
        }
        if ((access & 0x1000) != 0) {
            ++attributeCount;
        }
        if ((access & 0x20000) != 0) {
            ++attributeCount;
        }
        if (attrs != null) {
            attributeCount += attrs.getCount();
        }
        this.fields.putShort(attributeCount);
        if (value != null) {
            this.fields.putShort(this.newUTF8("ConstantValue"));
            this.fields.putInt(2).putShort(this.newConstItem((Object)value).index);
        }
        if ((access & 0x1000) != 0) {
            this.fields.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if ((access & 0x20000) != 0) {
            this.fields.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if (attrs != null) {
            attrs.put(this, null, 0, -1, -1, this.fields);
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        CodeWriter cw = new CodeWriter(this, this.computeMaxs);
        cw.init(access, name, desc, exceptions, attrs);
        return cw;
    }

    public void visitAttribute(Attribute attr) {
        attr.next = this.attrs;
        this.attrs = attr;
    }

    public void visitEnd() {
    }

    public byte[] toByteArray() {
        int size = 24 + 2 * this.interfaceCount;
        if (this.fields != null) {
            size += this.fields.length;
        }
        int nbMethods = 0;
        CodeWriter cb = this.firstMethod;
        while (cb != null) {
            ++nbMethods;
            size += cb.getSize();
            cb = cb.next;
        }
        int attributeCount = 0;
        if (this.sourceFile != 0) {
            ++attributeCount;
            size += 8;
        }
        if ((this.access & 0x20000) != 0) {
            ++attributeCount;
            size += 6;
        }
        if ((this.access & 0x1000) != 0) {
            ++attributeCount;
            size += 6;
        }
        if (this.innerClasses != null) {
            ++attributeCount;
            size += 8 + this.innerClasses.length;
        }
        if (this.attrs != null) {
            attributeCount += this.attrs.getCount();
            size += this.attrs.getSize(this, null, 0, -1, -1);
        }
        ByteVector out = new ByteVector(size += this.pool.length);
        out.putInt(-889275714).putInt(this.version);
        out.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        out.putShort(this.access).putShort(this.name).putShort(this.superName);
        out.putShort(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            out.putShort(this.interfaces[i]);
        }
        out.putShort(this.fieldCount);
        if (this.fields != null) {
            out.putByteArray(this.fields.data, 0, this.fields.length);
        }
        out.putShort(nbMethods);
        cb = this.firstMethod;
        while (cb != null) {
            cb.put(out);
            cb = cb.next;
        }
        out.putShort(attributeCount);
        if (this.sourceFile != 0) {
            out.putShort(this.newUTF8("SourceFile")).putInt(2).putShort(this.sourceFile);
        }
        if ((this.access & 0x20000) != 0) {
            out.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if ((this.access & 0x1000) != 0) {
            out.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if (this.innerClasses != null) {
            out.putShort(this.newUTF8("InnerClasses"));
            out.putInt(this.innerClasses.length + 2).putShort(this.innerClassesCount);
            out.putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.attrs != null) {
            this.attrs.put(this, null, 0, -1, -1, out);
        }
        return out.data;
    }

    Item newConstItem(Object cst) {
        if (cst instanceof Integer) {
            int val = (Integer)cst;
            return this.newInteger(val);
        }
        if (cst instanceof Byte) {
            int val = ((Byte)cst).intValue();
            return this.newInteger(val);
        }
        if (cst instanceof Character) {
            char val = ((Character)cst).charValue();
            return this.newInteger(val);
        }
        if (cst instanceof Short) {
            int val = ((Short)cst).intValue();
            return this.newInteger(val);
        }
        if (cst instanceof Boolean) {
            int val = (Boolean)cst != false ? 1 : 0;
            return this.newInteger(val);
        }
        if (cst instanceof Float) {
            float val = ((Float)cst).floatValue();
            return this.newFloat(val);
        }
        if (cst instanceof Long) {
            long val = (Long)cst;
            return this.newLong(val);
        }
        if (cst instanceof Double) {
            double val = (Double)cst;
            return this.newDouble(val);
        }
        if (cst instanceof String) {
            return this.newString((String)cst);
        }
        if (cst instanceof Type) {
            Type t = (Type)cst;
            return this.newClassItem(t.getSort() == 10 ? t.getInternalName() : t.getDescriptor());
        }
        throw new IllegalArgumentException("value " + cst);
    }

    public int newConst(Object cst) {
        return this.newConstItem((Object)cst).index;
    }

    public int newConstInt(int i) {
        return this.newInteger((int)i).index;
    }

    public int newConstLong(long l) {
        return this.newLong((long)l).index;
    }

    public int newConstFloat(float f) {
        return this.newFloat((float)f).index;
    }

    public int newConstDoule(double d) {
        return this.newDouble((double)d).index;
    }

    public int newUTF8(String value) {
        this.key.set(1, value, null, null);
        Item result = this.get(this.key);
        if (result == null) {
            this.pool.putByte(1).putUTF8(value);
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key);
            this.put(result);
        }
        return result.index;
    }

    public int newClass(String value) {
        return this.newClassItem((String)value).index;
    }

    private Item newClassItem(String value) {
        this.key2.set(7, value, null, null);
        Item result = this.get(this.key2);
        if (result == null) {
            this.pool.put12(7, this.newUTF8(value));
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key2);
            this.put(result);
        }
        return result;
    }

    public int newField(String owner, String name, String desc) {
        this.key3.set(9, owner, name, desc);
        Item result = this.get(this.key3);
        if (result == null) {
            this.put122(9, this.newClass(owner), this.newNameType(name, desc));
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key3);
            this.put(result);
        }
        return result.index;
    }

    Item newMethodItem(String owner, String name, String desc, boolean itf) {
        this.key3.set(itf ? 11 : 10, owner, name, desc);
        Item result = this.get(this.key3);
        if (result == null) {
            this.put122(itf ? 11 : 10, this.newClass(owner), this.newNameType(name, desc));
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key3);
            this.put(result);
        }
        return result;
    }

    public int newMethod(String owner, String name, String desc, boolean itf) {
        return this.newMethodItem((String)owner, (String)name, (String)desc, (boolean)itf).index;
    }

    private Item newInteger(int value) {
        this.key.set(value);
        Item result = this.get(this.key);
        if (result == null) {
            this.pool.putByte(3).putInt(value);
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key);
            this.put(result);
        }
        return result;
    }

    private Item newFloat(float value) {
        this.key.set(value);
        Item result = this.get(this.key);
        if (result == null) {
            this.pool.putByte(4).putInt(Float.floatToIntBits(value));
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key);
            this.put(result);
        }
        return result;
    }

    private Item newLong(long value) {
        this.key.set(value);
        Item result = this.get(this.key);
        if (result == null) {
            this.pool.putByte(5).putLong(value);
            result = new Item(this.index, this.key);
            this.put(result);
            this.index = (short)(this.index + 2);
        }
        return result;
    }

    private Item newDouble(double value) {
        this.key.set(value);
        Item result = this.get(this.key);
        if (result == null) {
            this.pool.putByte(6).putLong(Double.doubleToLongBits(value));
            result = new Item(this.index, this.key);
            this.put(result);
            this.index = (short)(this.index + 2);
        }
        return result;
    }

    private Item newString(String value) {
        this.key2.set(8, value, null, null);
        Item result = this.get(this.key2);
        if (result == null) {
            this.pool.put12(8, this.newUTF8(value));
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key2);
            this.put(result);
        }
        return result;
    }

    public int newNameType(String name, String desc) {
        this.key2.set(12, name, desc, null);
        Item result = this.get(this.key2);
        if (result == null) {
            this.put122(12, this.newUTF8(name), this.newUTF8(desc));
            short s = this.index;
            this.index = (short)(s + 1);
            result = new Item(s, this.key2);
            this.put(result);
        }
        return result.index;
    }

    private Item get(Item key) {
        int h = key.hashCode;
        Item i = this.items[h % this.items.length];
        while (i != null) {
            if (i.hashCode == h && key.isEqualTo(i)) {
                return i;
            }
            i = i.next;
        }
        return null;
    }

    private void put(Item i) {
        if (this.index > this.threshold) {
            Item[] newItems = new Item[this.items.length * 2 + 1];
            for (int l = this.items.length - 1; l >= 0; --l) {
                Item j = this.items[l];
                while (j != null) {
                    int index = j.hashCode % newItems.length;
                    Item k = j.next;
                    j.next = newItems[index];
                    newItems[index] = j;
                    j = k;
                }
            }
            this.items = newItems;
            this.threshold = (int)((double)this.items.length * 0.75);
        }
        int index = i.hashCode % this.items.length;
        i.next = this.items[index];
        this.items[index] = i;
    }

    private void put122(int b, int s1, int s2) {
        this.pool.put12(b, s1).putShort(s2);
    }

    static {
        byte[] b = new byte[220];
        String s = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(s.charAt(i) - 65);
        }
        TYPE = b;
    }
}

